/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.html;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import javax.xml.namespace.QName;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.AbstractIterator;
import oracle.dbtools.common.util.ChunkedInputStream;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.x3p.X3PAttribute;
import oracle.dbtools.common.x3p.X3PAttributes;
import oracle.dbtools.common.x3p.X3PFactory;
import oracle.dbtools.common.x3p.X3PHandler;
import oracle.dbtools.common.x3p.X3PReader;
import oracle.dbtools.rt.entity.Entities;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeaders;
import oracle.dbtools.rt.transcode.Transcoder;
import oracle.dbtools.rt.web.ContentType;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpHeader;
import oracle.dbtools.rt.web.Reason;
import oracle.dbtools.rt.web.WebException;

@Service
public class ApexHtmlTranscoder
implements Transcoder {
    private static final List<String> COMPACT_BOOLEAN = Arrays.asList("async", "compact", "nowrap", "ismap", "declare", "noshade", "checked", "disabled", "readonly", "multiple", "selected", "noresize", "defer", "itemscope", "scoped", "reversed", "pubdate", "seamless", "loop", "autoplay", "controls", "required", "autofocus", "novalidate", "formnovalidate", "open", "hidden");
    private static final ContentType[] FROM = new ContentType[]{ContentTypes.APEX_HTML, ContentTypes.XHTML};
    private static final List<String> NO_CLOSE_TAG = Arrays.asList("area", "base", "basefont", "br", "col", "frame", "hr", "img", "input", "isindex", "link", "meta", "param");
    private static final ContentType[] TO = new ContentType[]{ContentTypes.HTML};
    private static final String XHTML_NS = "http://www.w3.org/1999/xhtml";

    public Entity apply(Entity entity) {
        try {
            InputStream body = entity.body();
            EntityHeaders headers = entity.headers();
            return Entities.entity(this.transform(body), this.transform(headers));
        }
        catch (IOException e) {
            throw WebException.internalError(e, new Reason[0]);
        }
    }

    @Override
    public boolean canTransform(ContentType from, ContentType ... to) {
        return from.matches(FROM) && ContentType.matches(TO, to);
    }

    private EntityHeaders transform(EntityHeaders headers) {
        return Entities.merge(headers, Entities.headers(new CharSequence[]{HttpHeader.CONTENT_TYPE, ContentTypes.HTML}));
    }

    private InputStream transform(InputStream body) throws IOException {
        X3PReader r = X3PFactory.newReader((InputStream)body);
        return new ChunkedInputStream((ChunkedInputStream.Chunker)new HTMLChunker(r));
    }

    private static class HTMLWriter
    implements X3PHandler {
        private final Stack<Boolean> context = new Stack();
        private final Writer writer;

        private HTMLWriter(Writer writer) {
            this.writer = writer;
        }

        public void characters(char[] ch, int start, int length) {
            if (this.isHtml()) {
                try {
                    this.writer.write(ch, start, length);
                }
                catch (IOException e) {
                    throw WebException.internalError(e, new Reason[0]);
                }
            }
        }

        public void endDocument() {
        }

        public void endElement(QName name) {
            String tag = name.getLocalPart();
            if (this.isHtml() && this.requiresCloseTag(tag)) {
                try {
                    this.writer.append("</");
                    this.writer.append(tag);
                    this.writer.append(">");
                }
                catch (IOException e) {
                    throw WebException.internalError(e, new Reason[0]);
                }
            }
            this.context.pop();
        }

        public void endPrefixMapping(String prefix) {
        }

        public void processingInstruction(String target, String data) {
        }

        public void skippedEntity(String name) {
        }

        public void startDocument() {
        }

        public void startElement(QName name, X3PAttributes atts) {
            if (this.isHtml(name)) {
                this.context.push(true);
                try {
                    this.writer.append("<");
                    this.writer.append(name.getLocalPart());
                    for (X3PAttribute att : atts) {
                        if (!att.getName().getNamespaceURI().isEmpty()) continue;
                        this.writer.append(" ");
                        String key = att.getName().getLocalPart();
                        String value = att.getValue();
                        if (this.compactBoolean(key)) {
                            this.writer.append(key);
                            continue;
                        }
                        this.writer.append(key);
                        this.writer.append("=\"");
                        this.writer.append(value);
                        this.writer.append("\"");
                    }
                    this.writer.append(">");
                }
                catch (IOException e) {
                    throw WebException.internalError(e, new Reason[0]);
                }
            } else {
                this.context.push(false);
            }
        }

        public void startPrefixMapping(String prefix, String uri) {
        }

        private boolean compactBoolean(String attributeName) {
            return COMPACT_BOOLEAN.contains(attributeName);
        }

        private boolean isHtml() {
            return this.context.peek();
        }

        private boolean isHtml(QName name) {
            return ApexHtmlTranscoder.XHTML_NS.equals(name.getNamespaceURI()) || name.getNamespaceURI().isEmpty();
        }

        private boolean requiresCloseTag(String localPart) {
            return !NO_CLOSE_TAG.contains(localPart);
        }
    }

    private static final class HTMLChunker
    extends AbstractIterator<byte[]>
    implements ChunkedInputStream.Chunker {
        private final X3PReader r;
        private final StringWriter text;
        private final HTMLWriter w;

        HTMLChunker(X3PReader r) {
            this.r = r;
            this.text = new StringWriter();
            this.w = new HTMLWriter(this.text);
            r.setHandler((X3PHandler)this.w);
        }

        public void close() throws IOException {
            Closeables.close((Object)this.r);
        }

        protected byte[] advance() {
            try {
                byte[] chunk = null;
                boolean empty = true;
                boolean more = true;
                while (empty && more) {
                    more = this.r.next();
                    this.text.flush();
                    byte[] written = this.text.toString().getBytes(Charset.forName("UTF-8"));
                    empty = written.length == 0;
                    if (empty) continue;
                    chunk = written;
                    this.text.getBuffer().delete(0, this.text.getBuffer().length());
                }
                return chunk;
            }
            catch (IOException e) {
                throw WebException.internalError(e, new Reason[0]);
            }
        }
    }
}

