/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.config.setup;

import java.io.Console;
import java.util.Arrays;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.rt.config.setup.ConfigurationBuilder;
import oracle.dbtools.rt.config.setup.SetupMessages;

class Setting {
    private final String confKey;
    private String defaultValue;
    private final String[] legalValues;
    private String messageKey;
    private final boolean isPassword;

    static Setting setting(String messageKey, String confKey, String defaultValue) {
        return Setting.setting(messageKey, confKey, defaultValue, false, new String[0]);
    }

    static Setting setting(String messageKey, String confKey, String defaultValue, boolean isPassword, String ... legalValues) {
        return new Setting(messageKey, confKey, defaultValue, isPassword, legalValues);
    }

    String prompt(Console console, String ... messageArguments) {
        return this.prompt(console, (ConfigurationBuilder)null, messageArguments);
    }

    String prompt(Console console, ConfigurationBuilder conf, String ... messageArguments) {
        StringBuilder text = new StringBuilder();
        String prompt = SetupMessages.format(this.messageKey, messageArguments);
        boolean hasDefault = this.defaultValue != null;
        text.append(prompt);
        if (hasDefault) {
            text.append(" [");
            text.append(this.defaultValue);
            text.append("]");
        }
        text.append(":");
        String value = null;
        while (NullOrEmpty.nullOrEmpty(value)) {
            value = this.isPassword ? this.readPassword(console, text.toString()) : console.readLine(text.toString(), new Object[0]);
            if (NullOrEmpty.nullOrEmpty((CharSequence)value) && hasDefault) {
                value = this.defaultValue;
                continue;
            }
            if (NullOrEmpty.nullOrEmpty((Object[])this.legalValues) || this.isLegalValue(value)) continue;
            this.println(console, SetupMessages.format("ERR_INVALID_VALUE", new Object[0]));
            value = null;
        }
        if (this.confKey != null && conf != null) {
            conf.add(this.confKey, value);
        }
        return value;
    }

    void setDefaultValue(String defValue) {
        if (!NullOrEmpty.nullOrEmpty((CharSequence)defValue)) {
            this.defaultValue = defValue;
        }
    }

    void setMessageKey(String msgKey) {
        if (!NullOrEmpty.nullOrEmpty((CharSequence)msgKey)) {
            this.messageKey = msgKey;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String readPassword(Console c, String text) {
        String confirmPrompt = SetupMessages.format("DB_CONFIRM_PWD", new Object[0]);
        String doNotMatch = SetupMessages.format("DB_PWD_NOT_MATCH", new Object[0]);
        String emptyPassword = SetupMessages.format("DB_PWD_NON_EMPTY", new Object[0]);
        char[] first = new char[]{};
        try {
            boolean match = false;
            boolean empty = true;
            while (!match) {
                first = c.readPassword(text, new Object[0]);
                if (this.isEmpty(first)) {
                    this.println(c, emptyPassword);
                    continue;
                }
                char[] second = c.readPassword(confirmPrompt, new Object[0]);
                match = Arrays.equals(first, second);
                if (!match) {
                    this.println(c, doNotMatch);
                }
                Arrays.fill(second, ' ');
            }
            String string = "@" + Passwords.goingOut((String)String.valueOf(first));
            return string;
        }
        finally {
            Arrays.fill(first, ' ');
        }
    }

    private void println(Console c, String text) {
        if (c != null) {
            c.format(text, new Object[0]);
            c.format("%n", new Object[0]);
        }
    }

    private boolean isEmpty(char[] text) {
        boolean isWhitespace = true;
        for (int i = 0; i < text.length; ++i) {
            if (Character.isWhitespace(text[i])) continue;
            isWhitespace = false;
            break;
        }
        return isWhitespace;
    }

    private boolean isLegalValue(String value) {
        boolean valid = false;
        for (String s : this.legalValues) {
            if (!value.equals(s)) continue;
            valid = true;
            break;
        }
        return valid;
    }

    private Setting(String messageKey, String confKey, String defaultValue, boolean isPassword, String ... legalValues) {
        this.messageKey = messageKey;
        this.confKey = confKey;
        this.defaultValue = isPassword ? null : defaultValue;
        this.legalValues = legalValues;
        this.isPassword = isPassword;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Setting other = (Setting)obj;
        if (this.confKey == null ? other.confKey != null : !this.confKey.equals(other.confKey)) {
            return false;
        }
        if (this.defaultValue == null ? other.defaultValue != null : !this.defaultValue.equals(other.defaultValue)) {
            return false;
        }
        if (!Arrays.equals(this.legalValues, other.legalValues)) {
            return false;
        }
        return !(this.messageKey == null ? other.messageKey != null : !this.messageKey.equals(other.messageKey));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.confKey == null ? 0 : this.confKey.hashCode());
        result = 31 * result + (this.defaultValue == null ? 0 : this.defaultValue.hashCode());
        result = 31 * result + Arrays.hashCode(this.legalValues);
        result = 31 * result + (this.messageKey == null ? 0 : this.messageKey.hashCode());
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Setting [messageKey=");
        builder.append(this.messageKey);
        builder.append(", confKey=");
        builder.append(this.confKey);
        builder.append(", defaultValue=");
        builder.append(this.defaultValue);
        builder.append(", legalValues=");
        builder.append(Arrays.toString(this.legalValues));
        builder.append("]");
        return builder.toString();
    }
}

