/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.config.setup;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import oracle.dbtools.common.TranslatableMessage;
import oracle.dbtools.common.util.ConfigFiles;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.SortedProperties;
import oracle.dbtools.plugin.api.cmdline.CommandProvider;
import oracle.dbtools.plugin.api.cmdline.annotations.Argument;
import oracle.dbtools.plugin.api.cmdline.annotations.Command;
import oracle.dbtools.plugin.api.cmdline.annotations.Option;
import oracle.dbtools.plugin.api.di.annotations.Provides;
import oracle.dbtools.plugin.api.i18n.Translatable;
import oracle.dbtools.plugin.api.i18n.annotations.TranslatableText;
import oracle.dbtools.rt.config.setup.SetProperties;
import oracle.dbtools.rt.config.setup.SetupMessages;

@Provides
@Command(name="set-property", description=@TranslatableText(type=SetupMessages.class, id="SET_PROPERTY_DESCRIPTION"), options={@Option(name="conf", description=@TranslatableText(type=SetupMessages.class, id="SET_PROPERTY_CONF_OPTION"))}, arguments={@Argument(name="name", description=@TranslatableText(type=SetupMessages.class, id="SET_PROPERTY_NAME")), @Argument(name="value", description=@TranslatableText(type=SetupMessages.class, id="SET_PROPERTY_VALUE"))})
public class SetProperty
implements CommandProvider {
    private final File conf;
    private static final Log LOG = Log.get(SetProperties.class);
    private static final Translatable NO_PASSWORD = new TranslatableMessage(SetupMessages.class, "SET_PROPERTY_NO_PASSWORD", "", new Object[]{"setup-properties"});

    @Inject
    SetProperty(@Named(value="conf-folder") File conf) {
        this.conf = conf;
    }

    public void execute(Map<String, Object> values) throws Exception {
        String confName = (String)values.get("conf");
        if (confName == null) {
            confName = "defaults";
        }
        confName = confName.toLowerCase();
        String name = (String)values.get("name");
        if (name.toLowerCase().indexOf("password") != -1) {
            LOG.severe(NO_PASSWORD.toString());
        }
        String value = (String)values.get("value");
        File confFolder = Files.file((File)this.conf, (String)"conf/");
        File existingFile = Files.file((File)confFolder, (String)(confName + ".xml"));
        if ("defaults".equals(confName)) {
            existingFile = Files.file((File)this.conf, (String)(confName + ".xml"));
        }
        SortedProperties existing = new SortedProperties();
        ConfigFiles.load((Properties)existing, (File)existingFile);
        existing.put(name, value);
        ConfigFiles.save((Properties)existing, (File)existingFile);
        LOG.info("Modified: " + existingFile.getAbsolutePath() + ", settting: " + name + " = " + value);
    }
}

