/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.config.setup;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import oracle.dbtools.common.util.ConfigFiles;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Log;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.common.util.SortedProperties;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.plugin.api.cmdline.CommandProvider;
import oracle.dbtools.plugin.api.cmdline.annotations.Argument;
import oracle.dbtools.plugin.api.cmdline.annotations.Command;
import oracle.dbtools.plugin.api.cmdline.annotations.Option;
import oracle.dbtools.plugin.api.di.annotations.Provides;
import oracle.dbtools.plugin.api.i18n.annotations.TranslatableText;
import oracle.dbtools.rt.config.setup.SetupMessages;

@Provides
@Command(name="set-properties", description=@TranslatableText(type=SetupMessages.class, id="SET_PROPERTIES_DESCRIPTION"), options={@Option(name="conf", description=@TranslatableText(type=SetupMessages.class, id="SET_PROPERTIES_CONF_OPTION"))}, arguments={@Argument(name="path", description=@TranslatableText(type=SetupMessages.class, id="SET_PROPERTIES_PROP_FILE"))})
public class SetProperties
implements CommandProvider {
    private final File conf;
    private static final Log LOG = Log.get(SetProperties.class);

    @Inject
    SetProperties(@Named(value="conf-folder") File conf) {
        this.conf = conf;
    }

    public void execute(Map<String, Object> values) throws Exception {
        String confName = (String)values.get("conf");
        if (confName == null) {
            confName = "defaults";
        }
        confName = confName.toLowerCase();
        String path = (String)values.get("path");
        File propsFile = Files.file((String)path);
        if (propsFile.exists()) {
            File confFolder = Files.file((File)this.conf, (String)"conf/");
            File existingFile = Files.file((File)confFolder, (String)(confName + ".xml"));
            if ("defaults".equals(confName)) {
                existingFile = Files.file((File)this.conf, (String)(confName + ".xml"));
            }
            SortedProperties existing = new SortedProperties();
            ConfigFiles.load((Properties)existing, (File)existingFile);
            SortedProperties props = new SortedProperties();
            ConfigFiles.load((Properties)props, (File)propsFile);
            for (String name : Iterables.transform(props.keySet(), (Transform)Iterators.AS_STRING)) {
                String value = props.getProperty(name);
                if (SetProperties.isPassword(name) && !value.startsWith("@")) {
                    if (value.startsWith("!")) {
                        value = value.substring(1);
                    }
                    value = "@" + Passwords.goingOut((String)value);
                }
                existing.put(name, value);
            }
            ConfigFiles.save((Properties)existing, (File)existingFile);
            LOG.info("Modified: " + existingFile.getAbsolutePath() + ", updated properties: " + Iterables.join(props.keySet(), (String)", "));
        } else {
            LOG.severe((Throwable)new FileNotFoundException(path));
        }
    }

    private static boolean isPassword(String name) {
        return name.endsWith(".password");
    }
}

