/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.config.setup;

import java.io.Console;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import javax.inject.Inject;
import javax.inject.Named;
import oracle.dbtools.common.di.Factory;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Passwords;
import oracle.dbtools.common.util.SortedProperties;
import oracle.dbtools.plugin.api.cmdline.CommandProvider;
import oracle.dbtools.plugin.api.cmdline.annotations.Command;
import oracle.dbtools.plugin.api.cmdline.annotations.Option;
import oracle.dbtools.plugin.api.di.annotations.Provides;
import oracle.dbtools.plugin.api.i18n.annotations.TranslatableText;
import oracle.dbtools.rt.config.setup.InstallParams;
import oracle.dbtools.rt.config.setup.SchemaSetup;
import oracle.dbtools.rt.config.setup.Setting;
import oracle.dbtools.rt.config.setup.SetupMessages;

@Provides
@Command(name="schema", description=@TranslatableText(type=SetupMessages.class, id="SCHEMA_DESCR"), options={@Option(name="parameterFile", description=@TranslatableText(type=SetupMessages.class, id="PARAMETERFILE")), @Option(name="logDir", description=@TranslatableText(type=SetupMessages.class, id="INSTALL_LOGDIR")), @Option(name="silent", hasArgument=false, description=@TranslatableText(type=SetupMessages.class, id="SILENT_OPTION")), @Option(name="restart", hasArgument=false, description=@TranslatableText(type=SetupMessages.class, id="RESTART_ONLY_OPTION")), @Option(name="restartFile", description=@TranslatableText(type=SetupMessages.class, id="RESTART_FILE"))})
public class Schema
implements CommandProvider {
    private final Factory factory;
    private final File war;
    static final String ORDS_PUBLIC_USER = "ORDS_PUBLIC_USER";
    private static Setting PASSWORD = Setting.setting("DB_PWD", "db.password", null, true, new String[0]);
    private static Setting PORT = Setting.setting("DB_SERVER_PORT", "db.port", "1521");
    private static Setting SERVER = Setting.setting("DB_SERVER_NAME", "db.hostname", "localhost");
    private static Setting SERVICE_NAME = Setting.setting("DB_SERVICE_NAME", "db.servicename", null);
    private static final Setting SERVICE_OR_SID = Setting.setting("DB_CHOOSE_SID_OR_SERVICE", null, "1", false, "1", "2");
    private static Setting SID = Setting.setting("DB_SERVICE_ID", "db.sid", "xe");
    private static boolean isSimpleInstall;

    @Inject
    Schema(@Named(value="war") File war, Factory factory) {
        this.war = war;
        this.factory = factory;
    }

    public void execute(Map<String, Object> values) throws Exception {
        Map<String, String> installParams;
        String paramFile;
        String installType;
        boolean restart = false;
        if (values.get("restart") != null) {
            restart = (Boolean)values.get("restart");
        }
        if (NullOrEmpty.nullOrEmpty((CharSequence)(installType = (String)values.get("installtype")))) {
            installType = values.get("silent") != null && (Boolean)values.get("silent") != false ? "simple" : "advanced";
        }
        if (NullOrEmpty.nullOrEmpty((CharSequence)(paramFile = (String)values.get("paramfile")))) {
            paramFile = (String)values.get("parameterFile");
        }
        if ((installParams = InstallParams.getInstallParameters(this.war, installType, paramFile, (String)values.get("logDir"))) == null) {
            throw new Exception(SetupMessages.getString("ERR_INSTALL_PARAMS"));
        }
        isSimpleInstall = InstallParams.simpleInstall(installParams);
        Console console = System.console();
        if (restart) {
            String restartFile = (String)values.get("restartFile");
            if (NullOrEmpty.nullOrEmpty((CharSequence)restartFile)) {
                throw new Exception(SetupMessages.getString("ERR_MISSING_RESTART_FILE"));
            }
            installParams.put("restart.file", restartFile);
            this.validateRestartPropties(installParams);
            installParams.put("restart.only", "true");
        } else {
            installParams.put("schema.only", "true");
        }
        this.installOrUpgrade(console, (Class)values.get("installer"), installParams);
    }

    private void installOrUpgrade(Console console, Class<?> provider, Map<String, String> installParams) throws Exception {
        if (!Boolean.valueOf(installParams.get("bequeath.connect")).booleanValue()) {
            Schema.settingValue(console, installParams, "db.hostname", SERVER);
            Schema.settingValue(console, installParams, "db.port", PORT);
            this.sidOrServiceName(console, installParams);
        } else if (isSimpleInstall && !installParams.containsKey("rest.services.ords.add")) {
            installParams.put("rest.services.ords.add", "true");
        }
        SchemaSetup.schemaParams(console, this.war, installParams);
        if (this.requiresPublicUser(installParams)) {
            installParams.put("user.name.public", ORDS_PUBLIC_USER);
            Schema.settingValue(console, installParams, "db.password", PASSWORD, true, ORDS_PUBLIC_USER);
        }
        SchemaSetup.install(installParams, provider, this.factory);
    }

    private boolean requiresPublicUser(Map<String, String> installParams) {
        String installerType = installParams.get("installer");
        if (!NullOrEmpty.nullOrEmpty((CharSequence)installerType)) {
            String containerInfo;
            if (installerType.equals("install") || installerType.equals("cdb.install")) {
                return true;
            }
            if (installerType.equals("cdb.upgrade") && !NullOrEmpty.nullOrEmpty((CharSequence)(containerInfo = installParams.get("containers.info"))) && containerInfo.contains("install")) {
                return true;
            }
        }
        return false;
    }

    private void validateRestartPropties(Map<String, String> installParams) throws IOException {
        Properties prop = this.getProperties(installParams.get("restart.file"));
        if (prop.containsKey("container.process.list")) {
            if (NullOrEmpty.nullOrEmpty((CharSequence)prop.getProperty("container.process.list"))) {
                throw new IOException(SetupMessages.format("ERR_RESTART_MISSING_VALUE", "container.process.list"));
            }
        } else {
            throw new IOException(SetupMessages.format("ERR_RESTART_MISSING_PROPERTY", "container.process.list"));
        }
        installParams.put("container.process.list", prop.getProperty("container.process.list"));
        if (prop.containsKey("container.completed.list")) {
            installParams.put("container.completed.list", prop.getProperty("container.completed.list"));
        }
    }

    private void sidOrServiceName(Console console, Map<String, String> installParams) throws Exception {
        if (!NullOrEmpty.nullOrEmpty((CharSequence)installParams.get("db.servicename")) && isSimpleInstall) {
            Schema.settingValue(console, installParams, "db.servicename", SERVICE_NAME);
        } else if (!NullOrEmpty.nullOrEmpty((CharSequence)installParams.get("db.sid")) && isSimpleInstall) {
            Schema.settingValue(console, installParams, "db.sid", SID);
        } else if (console != null) {
            String choice = SERVICE_OR_SID.prompt(console, new String[0]);
            if ("1".equals(choice)) {
                Schema.settingValue(console, installParams, "db.servicename", SERVICE_NAME);
                installParams.remove("db.sid");
            } else {
                Schema.settingValue(console, installParams, "db.sid", SID);
                installParams.remove("db.servicename");
            }
        } else {
            if (isSimpleInstall) {
                String keys = "db.servicename or db.sid";
                throw new Exception(SetupMessages.format("ERR_MISSING_VALUE_SIMPLE", keys));
            }
            throw new Exception(SetupMessages.getString("ERR_NO_CONSOLE_ADVANCED"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties getProperties(String filename) throws IOException {
        SortedProperties properties = new SortedProperties();
        File file = Files.file((String)filename);
        if (file.exists()) {
            InputStream in = null;
            try {
                in = Files.inputStream((File)file);
                properties.load(in);
            }
            finally {
                Closeables.close((Object)in);
            }
        } else {
            throw new IOException(SetupMessages.getString("ERR_RESTART_FILE_NOT_EXIST"));
        }
        return properties;
    }

    private static String settingValue(Console console, Map<String, String> installParams, String key, Setting setting) throws Exception {
        return Schema.settingValue(console, installParams, key, setting, false, null);
    }

    private static String settingValue(Console console, Map<String, String> installParams, String key, Setting setting, boolean isPassword, String user) throws Exception {
        String val = null;
        String pwKey = null;
        if (isPassword) {
            pwKey = user.equalsIgnoreCase(ORDS_PUBLIC_USER) ? "user.public.password" : (user.equalsIgnoreCase("APEX_LISTENER") ? "user.apex.listener.password" : (user.equalsIgnoreCase("APEX_REST_PUBLIC_USER") ? "user.apex.restpublic.password" : "db.password"));
            val = installParams.get(pwKey);
            if (!NullOrEmpty.nullOrEmpty((CharSequence)val) && !val.startsWith("@")) {
                val = "@" + Passwords.goingOut((String)val);
                installParams.put(pwKey, val);
            }
        } else {
            val = installParams.get(key);
        }
        if (console != null) {
            if (!isSimpleInstall || NullOrEmpty.nullOrEmpty((CharSequence)val)) {
                if (isPassword) {
                    val = setting.prompt(console, user);
                    installParams.put(pwKey, val);
                } else {
                    if (!NullOrEmpty.nullOrEmpty((CharSequence)val)) {
                        setting.setDefaultValue(val);
                    }
                    val = setting.prompt(console, null);
                    installParams.put(key, val);
                }
            }
        } else if (isSimpleInstall) {
            if (NullOrEmpty.nullOrEmpty((CharSequence)val)) {
                throw new Exception(SetupMessages.format("ERR_MISSING_VALUE_SIMPLE", isPassword ? pwKey : key));
            }
        } else {
            throw new Exception(SetupMessages.getString("ERR_NO_CONSOLE_ADVANCED"));
        }
        return val;
    }
}

