/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authorization;

import java.io.File;
import java.security.Principal;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.concurrent.atomic.AtomicReference;
import oracle.dbtools.common.config.file.ConfigurationFolder;
import oracle.dbtools.common.jdbc.JDBCPrincipal;
import oracle.dbtools.common.service.ServiceProperties;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.AnonymousPrincipal;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.AssociativeArrays;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.rt.authorization.RoleMapper;
import oracle.dbtools.rt.authorization.RoleMappings;
import oracle.dbtools.rt.authorization.RoleMembership;
import oracle.dbtools.rt.csv.CommaSeparatedValues;
import oracle.dbtools.rt.tenants.TenantPrincipal;
import oracle.dbtools.rt.web.HasRoles;

@Service(provides={RoleMapper.class, AdditionalRolesMapper.class})
public class AdditionalRolesMapper
implements RoleMapper {
    private final AtomicReference<RoleMappings> roleMappings = new AtomicReference<RoleMappings>(new RoleMappings((AssociativeArray<String, String>)AssociativeArrays.empty()));
    private static final NotInfrastructurePrincipal NOT_INFRA_PRINCIPAL = new NotInfrastructurePrincipal();
    private static final String ROLE_FILE = "role-mapping.xml";

    @Override
    public RoleMembership isPrincipalInRole(CompoundPrincipal principal, String role) {
        RoleMembership membership = RoleMembership.NOT_KNOWN;
        Collection<String> allRoles = this.toRoles((Iterable<Principal>)principal, role);
        RoleMappings roleMappings = this.roleMappings.get();
        allRoles = roleMappings.map(allRoles);
        if (allRoles.contains(role)) {
            membership = RoleMembership.MEMBER;
        }
        return membership;
    }

    public void map(String from, String ... to) {
        RoleMappings roleMappings = this.roleMappings.get();
        if (roleMappings != null) {
            String target = CommaSeparatedValues.string(to);
            this.roleMappings.compareAndSet(roleMappings, roleMappings.add((AssociativeArray<String, String>)AssociativeArrays.asArray((Object[])new String[]{from, target})));
        }
    }

    protected void activate(ServiceProperties properties) throws Exception {
        File mappings = Files.file((File)ConfigurationFolder.INSTANCE.getFolder(), (String)ROLE_FILE);
        this.roleMappings.set(new RoleMappings(mappings));
    }

    private Collection<String> toRoles(Iterable<Principal> principals, String requiredRole) {
        HasRoles moreRoles;
        LinkedHashSet<String> all = new LinkedHashSet<String>();
        Iterable<Principal> filtered = this.filtered(principals);
        Principal user = (Principal)Iterables.first(filtered);
        if (user instanceof HasRoles && (moreRoles = (HasRoles)((Object)user)).isInRole(requiredRole)) {
            all.add(requiredRole);
        }
        Iterable roles = Iterables.subsequent(filtered);
        for (Principal principal : roles) {
            HasRoles moreRoles2;
            String name = principal.getName();
            if (name != null) {
                all.add(name);
            }
            if (!(principal instanceof HasRoles) || !(moreRoles2 = (HasRoles)((Object)principal)).isInRole(requiredRole)) continue;
            all.add(requiredRole);
        }
        return all;
    }

    private Iterable<Principal> filtered(Iterable<Principal> principals) {
        return Iterables.select(principals, (Selector)NOT_INFRA_PRINCIPAL);
    }

    private static final class NotInfrastructurePrincipal
    implements Selector<Principal> {
        private NotInfrastructurePrincipal() {
        }

        public Boolean apply(Principal x) {
            if (x instanceof TenantPrincipal || x instanceof JDBCPrincipal || x == AnonymousPrincipal.ANONYMOUS) {
                return false;
            }
            return true;
        }
    }
}

