/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.authentication;

import java.util.Map;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.rt.authentication.LogonRealm;
import oracle.dbtools.rt.authentication.SecurityConfigs;
import oracle.dbtools.rt.session.SessionState;
import oracle.dbtools.rt.web.ContentTypes;
import oracle.dbtools.rt.web.HttpMethod;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.RequestHandlerMetaData;
import oracle.dbtools.rt.web.ResourceDispatcher;
import oracle.dbtools.rt.web.TemplateRequestHandler;
import oracle.dbtools.rt.web.TemplateResourceGenerator;

@Service(provides={ResourceDispatcher.class})
public class LoggedOffHandler
extends TemplateRequestHandler {
    private static final RequestHandlerMetaData META_DATA = RequestHandlerMetaData.builder(LogonRealm.loggedOffTemplate(), HttpMethod.GET).securityConfig(SecurityConfigs.SECURE).build();
    private static final TemplateResourceGenerator TEMPLATE = TemplateResourceGenerator.templateFromUrl((CharSequence)((Object)ContentTypes.HTML), "signed-out.html", new String[0]);

    public LoggedOffHandler() {
        super(META_DATA, TEMPLATE);
    }

    @Override
    protected Map<String, String> values(RequestEntity request) {
        SessionState sessionState = SessionState.session(request);
        Map<String, String> values = META_DATA.uriTemplate().decode(request.path());
        values.put("base", request.base());
        if (sessionState == null) {
            LogonRealm realm = LogonRealm.realm(request);
            values.put("start-path", realm.defaultStartPath());
        } else {
            values.put("start-path", sessionState.startPath());
        }
        return values;
    }
}

