/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.xml;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javax.inject.Inject;
import javax.xml.transform.Result;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.common.util.Text;
import oracle.dbtools.common.xml.NormalizedSAXResult;
import oracle.dbtools.common.xml.XMLSerializerOptions;
import oracle.dbtools.common.xml.XMLSerializerOptionsImpl;
import oracle.dbtools.common.xml.XMLSerializers;
import oracle.dbtools.plugin.api.di.annotations.Provides;

@Provides
public class XMLSerializersProvider
implements XMLSerializers {
    @Inject
    public XMLSerializersProvider() {
    }

    @Override
    public Result serializer(OutputStream out, XMLSerializerOptions options) {
        return this.serializer(new StreamResult(new OutputStreamWriter(out, Text.defaultCharset())), options);
    }

    @Override
    public Result serializer(Writer out, XMLSerializerOptions options) {
        return this.serializer(new StreamResult(out), options);
    }

    private Result serializer(StreamResult out, XMLSerializerOptions options) {
        return new NormalizedSAXResult(out, options);
    }

    @Override
    public XMLSerializerOptions.Builder options() {
        return new XMLSerializerOptionsImpl.Builder();
    }
}

