/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.xml;

import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.sax.SAXTransformerFactory;
import javax.xml.transform.sax.TransformerHandler;
import javax.xml.transform.stream.StreamResult;
import oracle.dbtools.common.xml.ForceTransformerFactory;
import oracle.dbtools.common.xml.NewlineNormalizer;
import oracle.dbtools.common.xml.XMLSerializerOptions;
import oracle.dbtools.common.xml.XmlDecl;
import org.xml.sax.ContentHandler;
import org.xml.sax.ext.LexicalHandler;

class NormalizedSAXResult
extends SAXResult {
    private static final String INDENT_WIDTH = "indent-number";

    NormalizedSAXResult(StreamResult out, XMLSerializerOptions options) {
        super.setHandler(NormalizedSAXResult.contentHandler(out, options));
    }

    @Override
    public void setHandler(ContentHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setLexicalHandler(LexicalHandler handler) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSystemId(String systemId) {
        throw new UnsupportedOperationException();
    }

    private static ContentHandler contentHandler(StreamResult out, XMLSerializerOptions options) {
        TransformerFactory transFact = ForceTransformerFactory.newInstance();
        SAXTransformerFactory saxTransFact = (SAXTransformerFactory)transFact;
        try {
            if (options.indent() >= 0) {
                saxTransFact.setAttribute(INDENT_WIDTH, options.indent());
            }
            TransformerHandler h = saxTransFact.newTransformerHandler();
            Transformer t = h.getTransformer();
            t.setOutputProperty("omit-xml-declaration", "yes");
            if (options.indent() >= 0) {
                t.setOutputProperty("indent", "yes");
            } else {
                t.setOutputProperty("indent", "no");
            }
            if (options.cdataElements().size() > 0) {
                t.setOutputProperty("cdata-section-elements", NormalizedSAXResult.cdata(options.cdataElements()));
            }
            StreamResult output = NewlineNormalizer.normalize(out);
            h.setResult(output);
            return new XmlDecl(options.emitDecl(), h, out.getWriter());
        }
        catch (TransformerConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    private static String cdata(Set<QName> cData) {
        StringBuilder b = new StringBuilder();
        for (QName element : cData) {
            String ns = element.getNamespaceURI();
            String localPart = element.getLocalPart();
            if (!ns.isEmpty()) {
                b.append(ns);
                b.append(':');
            }
            b.append(localPart);
            b.append(' ');
        }
        return b.toString();
    }
}

