/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.x3p.impl;

import java.io.IOException;
import oracle.dbtools.common.util.AbstractIterator;
import oracle.dbtools.common.util.ChunkedInputStream;
import oracle.dbtools.common.x3p.X3PReader;
import oracle.dbtools.common.x3p.X3PWriterOptions;
import oracle.dbtools.common.x3p.impl.X3PChunkedWriter;

final class X3PStream
extends ChunkedInputStream {
    public X3PStream(X3PReader input, X3PWriterOptions options) throws IOException {
        super(new XmlChunker(input, options));
    }

    private static class XmlChunker
    extends AbstractIterator<byte[]>
    implements ChunkedInputStream.Chunker {
        private final X3PChunkedWriter output;
        private final X3PReader reader;

        public XmlChunker(X3PReader input, X3PWriterOptions options) throws IOException {
            this.reader = input;
            this.output = new X3PChunkedWriter(options);
            this.reader.setHandler(this.output);
        }

        @Override
        public byte[] advance() {
            try {
                byte[] chunk = null;
                boolean empty = true;
                boolean more = true;
                while (empty && more) {
                    more = this.reader.next();
                    String text = this.output.toString();
                    empty = text.isEmpty();
                    if (empty) continue;
                    chunk = text.getBytes("UTF-8");
                    this.output.reset();
                }
                return chunk;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (RuntimeException e) {
                throw e;
            }
        }

        @Override
        public void close() throws IOException {
            this.reader.close();
        }
    }
}

