/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.x3p;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Stack;

public class Namespaces {
    private final Bindings candidates = new Bindings();
    private Handler handler;
    private final Stack<Bindings> scope = new Stack();
    private static final String XML_NS = "http://www.w3.org/XML/1998/";
    private static final String XML_NS_NS = "http://www.w3.org/XML/1998/namespace";

    public Namespaces() {
        this(null);
    }

    public Namespaces(Handler handler) {
        this.handler = handler;
    }

    public void add(String prefix, String uri) {
        this.candidates.put(prefix, uri);
    }

    public void clear() {
        this.scope.clear();
    }

    public LinkedHashMap<String, String> enter() {
        this.scope.push(new Bindings());
        for (Map.Entry<String, String> entry : this.candidates.entrySet()) {
            if (this.inScope(entry)) continue;
            this.scope.peek().put(entry.getKey(), entry.getValue());
            if (this.handler == null) continue;
            this.handler.start(entry.getKey(), entry.getValue());
        }
        this.candidates.clear();
        return this.scope.peek();
    }

    public LinkedHashMap<String, String> exit() {
        for (String prefix : this.scope.peek().keySet()) {
            if (this.handler == null) continue;
            this.handler.end(prefix);
        }
        return this.scope.pop();
    }

    public void handler(Handler handler) {
        this.handler = handler;
    }

    public String namespace(String prefix) {
        if (this.scope.isEmpty()) {
            return "";
        }
        for (int i = this.scope.size() - 1; i >= 0; --i) {
            Bindings ns = (Bindings)this.scope.get(i);
            String namespace = (String)ns.get(prefix);
            if (namespace == null) continue;
            return namespace;
        }
        return "";
    }

    public String toString() {
        return "Namespaces [scope=" + this.scope + "]";
    }

    private boolean inScope(Map.Entry<String, String> binding) {
        boolean inScope = false;
        String prefix = binding.getKey();
        String uri = binding.getValue();
        if ("".equals(uri) || XML_NS.equals(uri) || XML_NS_NS.equals(uri) || "xml".equals(prefix)) {
            return true;
        }
        if (this.scope.isEmpty()) {
            return false;
        }
        for (int i = this.scope.size() - 1; i >= 0; --i) {
            Bindings ns = (Bindings)this.scope.get(i);
            for (Map.Entry n : ns.entrySet()) {
                String np = (String)n.getKey();
                String nu = (String)n.getValue();
                if (!np.equals(prefix) || !nu.equals(uri)) continue;
                inScope = true;
                break;
            }
            if (inScope) break;
        }
        return inScope;
    }

    private static class Bindings
    extends LinkedHashMap<String, String> {
        private static final long serialVersionUID = 1L;

        private Bindings() {
        }
    }

    public static interface Handler {
        public void end(String var1);

        public void start(String var1, String var2);
    }
}

