/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.math.BigDecimal;
import java.math.RoundingMode;

public class Sampler {
    private volatile Snapshot current = new Snapshot(0L, 0L, 0L, 0L, 0L, BigDecimal.ZERO);

    public Sampler add(long sample) {
        long minimum;
        Snapshot current = this.current;
        long count = current.count + 1L;
        long total = current.total + sample;
        long l = minimum = sample < current.minimum ? sample : current.minimum;
        if (count == 1L) {
            minimum = sample;
        }
        long maximum = sample > current.maximum ? sample : current.maximum;
        BigDecimal average = this.avg(total, count);
        this.current = new Snapshot(sample, total, minimum, maximum, count, average);
        return this;
    }

    public Snapshot snapshot() {
        return this.current;
    }

    public String toString() {
        return this.snapshot().toString();
    }

    private BigDecimal avg(long total, long count) {
        return this.divide(total, count);
    }

    private BigDecimal divide(long number, long divisor) {
        if (divisor == 0L) {
            return BigDecimal.ZERO;
        }
        BigDecimal total = new BigDecimal(number);
        BigDecimal size = new BigDecimal(divisor);
        return total.divide(size, RoundingMode.HALF_UP);
    }

    public static class Snapshot {
        private final BigDecimal average;
        private final long count;
        private final long current;
        private final long maximum;
        private final long minimum;
        private final long total;

        public Snapshot(long current, long total, long minimum, long maximum, long count, BigDecimal average) {
            this.current = current;
            this.total = total;
            this.maximum = maximum;
            this.minimum = minimum;
            this.count = count;
            this.average = average;
        }

        public BigDecimal getAverage() {
            return this.average;
        }

        public long getCount() {
            return this.count;
        }

        public long getCurrent() {
            return this.current;
        }

        public long getMaximum() {
            return this.maximum;
        }

        public long getMinimum() {
            return this.minimum;
        }

        public long getTotal() {
            return this.total;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Snapshot [minimum=");
            builder.append(this.minimum);
            builder.append(", average=");
            builder.append(this.average);
            builder.append(", maximum=");
            builder.append(this.maximum);
            builder.append(", total=");
            builder.append(this.total);
            builder.append("]");
            return builder.toString();
        }
    }
}

