/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.util.Selector;

public abstract class Reflections {
    private static final Class<?>[] PRIMITIVES = new Class[]{String.class, Integer.class, Boolean.class, Double.class, Long.class, Short.class, Byte.class, Character.class, Float.class, BigDecimal.class, BigInteger.class};

    public static Iterable<Annotation> annotations(Class<?> clazz) {
        return Arrays.asList(clazz.getAnnotations());
    }

    public static Iterable<Annotation> annotations(Field f) {
        return Arrays.asList(f.getAnnotations());
    }

    public static boolean available(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static boolean available(String className, String methodName, String ... parameterTypeNames) {
        try {
            Class<?> clazz = Class.forName(className);
            Class[] parameterTypes = new Class[parameterTypeNames.length];
            for (int i = 0; i < parameterTypeNames.length; ++i) {
                parameterTypes[i] = Class.forName(parameterTypeNames[i]);
            }
            clazz.getMethod(methodName, parameterTypes);
            return true;
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return false;
    }

    public static Class<?> clazz(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            throw UnrecoverableException.unrecoverable(e);
        }
    }

    public static <T> Constructor<T> constructor(Class<T> clazz, Class<?> ... parameterTypes) {
        try {
            return clazz.getDeclaredConstructor(parameterTypes);
        }
        catch (Exception e) {
            throw UnrecoverableException.unrecoverable(e);
        }
    }

    public static Iterable<Method> declaredMethods(Class<?> clazz) {
        return Arrays.asList(clazz.getDeclaredMethods());
    }

    public static Field field(Class<?> clazz, String name) throws NoSuchFieldException {
        Field field = null;
        for (Class<?> curr = clazz; field == null && curr != null && !curr.equals(Object.class); curr = curr.getSuperclass()) {
            try {
                field = curr.getDeclaredField(name);
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (null == field) {
            throw new NoSuchFieldException(name);
        }
        return field;
    }

    public static Iterable<Field> fields(Class<?> clazz) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> curr = clazz; curr != null && !curr.equals(Object.class); curr = curr.getSuperclass()) {
            Field[] current;
            for (Field field : current = curr.getDeclaredFields()) {
                fields.add(field);
            }
        }
        return fields;
    }

    public static Object fieldValue(Object instance, Field f) {
        if (instance != null) {
            f.setAccessible(true);
            try {
                return f.get(instance);
            }
            catch (Exception e) {
                throw UnrecoverableException.unrecoverable(e);
            }
        }
        return null;
    }

    public static Object fieldValue(Object instance, String name) {
        if (instance != null) {
            try {
                Field f = Reflections.field(instance.getClass(), name);
                f.setAccessible(true);
                return f.get(instance);
            }
            catch (Exception e) {
                throw UnrecoverableException.unrecoverable(e);
            }
        }
        return null;
    }

    public static void fieldValue(Object instance, String name, Object value) {
        if (instance != null) {
            try {
                Field f = Reflections.field(instance.getClass(), name);
                f.setAccessible(true);
                if (f.getType().isPrimitive() && null == value) {
                    return;
                }
                f.set(instance, value);
            }
            catch (Exception e) {
                throw UnrecoverableException.unrecoverable(e);
            }
        }
    }

    public static Selector<Field> hasAnnotations() {
        return new Selector<Field>(){

            @Override
            public Boolean apply(Field x) {
                return x.getAnnotations().length > 0;
            }
        };
    }

    public static boolean isPrimitive(Class<?> type) {
        boolean isPrimitive = type.isPrimitive();
        if (!isPrimitive) {
            for (Class<?> c : PRIMITIVES) {
                if (!c.equals(type)) continue;
                isPrimitive = true;
                break;
            }
        }
        return isPrimitive;
    }

    public static boolean matches(Method expected, Method actual) {
        return expected.getName().equals(actual.getName()) && Arrays.equals(expected.getParameterTypes(), actual.getParameterTypes());
    }

    public static Method method(Class<?> clazz, String name, Class<?> ... parameterTypes) {
        if (clazz == null || name == null || parameterTypes == null) {
            throw new NullPointerException();
        }
        try {
            for (Method m : clazz.getDeclaredMethods()) {
                if (!name.equals(m.getName()) || !Arrays.equals(parameterTypes, m.getParameterTypes())) continue;
                return m;
            }
            throw new NoSuchMethodException(name + '(' + Arrays.toString(parameterTypes) + ')');
        }
        catch (Exception e) {
            throw UnrecoverableException.unrecoverable(e);
        }
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw UnrecoverableException.unrecoverable(e);
        }
    }

    public static <T> T newInstance(Constructor<T> ctor, Object ... args) {
        try {
            ctor.setAccessible(true);
            return ctor.newInstance(args);
        }
        catch (Exception e) {
            throw UnrecoverableException.unrecoverable(e);
        }
    }
}

