/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.util.Iterator;
import oracle.dbtools.common.util.AssociativeArray;
import oracle.dbtools.common.util.FormFields;
import oracle.dbtools.common.util.MultiAssociativeArray;
import oracle.dbtools.common.util.MultiAssociativeArrays;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.Pair;
import oracle.dbtools.common.util.URLEncoding;

public class QueryString
extends FormFields {
    private final String fragment;
    private final String path;
    private static final MultiAssociativeArray<String, String> EMPTY_QUERY_STRING = MultiAssociativeArrays.builder().build();
    private static final MultiAssociativeArray<String, String> NO_QUERY_STRING = MultiAssociativeArrays.builder().build();

    private QueryString(String path, MultiAssociativeArray<String, String> parameters, String fragment) {
        super(parameters);
        this.path = path;
        this.fragment = fragment;
    }

    public String path() {
        return this.path;
    }

    public QueryString put(AssociativeArray<String, String> values) {
        return this.queryString(this.parameters().put(values));
    }

    public QueryString put(String key, String value) {
        return this.queryString(this.parameters().put(key, value));
    }

    public QueryString remove(MultiAssociativeArray<String, String> toRemove) {
        return this.queryString(this.parameters().remove(toRemove));
    }

    public QueryString remove(String key) {
        return this.queryString(this.parameters().remove(key));
    }

    public QueryString remove(String key, String value) {
        return this.queryString(this.parameters().remove(key, value));
    }

    @Override
    public MultiAssociativeArray<String, String> replace(MultiAssociativeArray<String, String> toReplace) {
        return this.queryString(this.parameters().replace(toReplace));
    }

    public QueryString replace(String key, String value) {
        return this.queryString(this.parameters().replace(key, value));
    }

    @Override
    public String toString() {
        StringBuilder b = new StringBuilder(this.path);
        if (this.parameters() != NO_QUERY_STRING) {
            b.append('?');
            b.append(this.encode(this.values().iterator()));
        }
        if (this.fragment != null) {
            b.append('#');
            b.append(this.fragment);
        }
        return b.toString();
    }

    private String apexify(String encoded) {
        return encoded.replaceAll("%3A", ":");
    }

    private String encode(Iterator<Pair<String, String>> values) {
        StringBuilder b = new StringBuilder();
        while (values.hasNext()) {
            Pair<String, String> value = values.next();
            String key = this.encode(value.first());
            String val = this.encode(value.second());
            b.append(key);
            if (!NullOrEmpty.nullOrEmpty(val)) {
                b.append('=');
                b.append(val);
            }
            if (!values.hasNext()) continue;
            b.append('&');
        }
        return b.toString();
    }

    private String encode(String text) {
        if (text == null) {
            return null;
        }
        String encoded = URLEncoding.encode(text);
        encoded = this.apexify(encoded);
        return encoded;
    }

    private QueryString queryString(MultiAssociativeArray<String, String> parameters) {
        if (NullOrEmpty.nullOrEmpty(parameters)) {
            return new QueryString(this.path, NO_QUERY_STRING, null);
        }
        return new QueryString(this.path, parameters, null);
    }

    public static QueryString parse(String path) {
        String[] segments;
        int questionMark = path.indexOf("?");
        int hash = path.lastIndexOf(35);
        if (questionMark == -1) {
            String fragment = null;
            if (hash != -1) {
                fragment = path.substring(hash + 1);
                path = path.substring(0, hash);
            }
            return new QueryString(path, NO_QUERY_STRING, fragment);
        }
        String text = path.substring(questionMark + 1);
        String fragment = null;
        if (hash != -1) {
            text = path.substring(questionMark + 1, hash);
            fragment = path.substring(hash + 1);
        }
        path = path.substring(0, questionMark);
        if (NullOrEmpty.nullOrEmpty(text)) {
            return new QueryString(path, EMPTY_QUERY_STRING, fragment);
        }
        MultiAssociativeArrays.Builder<String, String> parameters = MultiAssociativeArrays.builder();
        for (String segment : segments = text.split("&")) {
            String value;
            String key;
            int equals = segment.indexOf(61);
            if (equals == -1) {
                key = segment;
                value = "";
            } else {
                key = segment.substring(0, equals);
                value = equals == segment.length() - 1 ? "" : segment.substring(equals + 1, segment.length());
            }
            key = QueryString.decode(key);
            value = QueryString.decode(value);
            parameters.add(key, value);
        }
        return new QueryString(path, parameters.build(), fragment);
    }

    private static String decode(String maybeEncoded) {
        if (!NullOrEmpty.nullOrEmpty(maybeEncoded)) {
            try {
                return URLEncoding.decode(maybeEncoded);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        return maybeEncoded;
    }
}

