/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.util.Iterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import oracle.dbtools.common.util.Forms;
import oracle.dbtools.common.util.MissingFormFieldException;
import oracle.dbtools.common.util.MultiAssociativeArray;
import oracle.dbtools.common.util.MultiAssociativeArrays;
import oracle.dbtools.common.util.Pair;

public class FormFields
extends MultiAssociativeArrays.Base<String, String> {
    private final MultiAssociativeArray<String, String> parameters;

    public FormFields(HttpServletRequest request) {
        this(FormFields.formFields(request));
    }

    public FormFields(MultiAssociativeArray<String, String> parameters) {
        this.parameters = parameters;
    }

    public String getRequiredField(String name) throws MissingFormFieldException {
        String text = (String)this.get(name);
        if (text == null) {
            throw new MissingFormFieldException(name);
        }
        return text;
    }

    @Override
    public Iterator<String> iterator() {
        return this.parameters.iterator();
    }

    @Override
    public int size() {
        return this.parameters.size();
    }

    @Override
    public String toString() {
        return FormFields.toString(this);
    }

    @Override
    public Iterable<Pair<String, String>> values() {
        return this.parameters.values();
    }

    @Override
    public Iterable<String> values(Object key) {
        return this.parameters.values(key);
    }

    protected MultiAssociativeArray<String, String> parameters() {
        return this.parameters;
    }

    public static String toString(MultiAssociativeArray<String, String> values) {
        return Forms.encode(values.values().iterator());
    }

    private static MultiAssociativeArray<String, String> formFields(HttpServletRequest request) {
        MultiAssociativeArrays.Builder<String, String> fields = MultiAssociativeArrays.builder();
        Map parameters = request.getParameterMap();
        if (parameters != null) {
            for (String name : parameters.keySet()) {
                String[] values;
                for (String value : values = (String[])parameters.get(name)) {
                    fields.add(name, value);
                }
            }
        }
        return fields.build();
    }
}

