/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.DigestInputStream;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import oracle.dbtools.common.UnrecoverableException;
import oracle.dbtools.common.util.Text;

public abstract class Digests {
    private static final int BUFFER_SIZE = 4096;
    private static final String HASH_ALGORITHM = "SHA-512";

    private Digests() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public static byte[] digest(byte[] bytes) throws IOException {
        return Digests.builder().digest(bytes).build();
    }

    public static byte[] digest(InputStream stream) throws IOException {
        return Digests.builder().digest(stream).build();
    }

    public static byte[] digest(CharSequence text) throws IOException {
        return Digests.builder().digest(text).build();
    }

    public static boolean equals(byte[] digest1, byte[] digest2) {
        return MessageDigest.isEqual(digest1, digest2);
    }

    public static class Builder {
        private final MessageDigest d;

        Builder() {
            try {
                this.d = MessageDigest.getInstance(Digests.HASH_ALGORITHM);
            }
            catch (NoSuchAlgorithmException e) {
                throw UnrecoverableException.unrecoverable(e);
            }
        }

        public byte[] build() {
            return this.d.digest();
        }

        public Builder digest(byte[] bytes) throws IOException {
            this.d.update(bytes);
            return this;
        }

        public Builder digest(byte[] bytes, int offset, int length) throws IOException {
            this.d.update(bytes, offset, length);
            return this;
        }

        public Builder digest(CharSequence text) throws IOException {
            if (text != null) {
                byte[] bytes = text.toString().getBytes(Text.defaultCharset());
                return this.digest(bytes);
            }
            return this;
        }

        public Builder digest(InputStream stream) throws IOException {
            byte[] bytes = new byte[4096];
            int numread = stream.read(bytes);
            while (numread != -1) {
                this.d.update(bytes, 0, numread);
                numread = stream.read(bytes);
            }
            return this;
        }

        public InputStream stream(InputStream stream) throws IOException {
            return new DigestInputStream(stream, this.d);
        }

        public OutputStream stream(OutputStream output) throws IOException {
            return new DigestOutputStream(output, this.d);
        }

        public String toString() {
            return this.d.toString();
        }
    }
}

