/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;

public class ChunkedInputStream
extends InputStream {
    private byte[] chunk;
    private final Chunker chunker;
    private int pos = 0;
    private boolean started = false;
    private static final int CHUNK_SIZE = 8192;
    private static final int EOS = -1;

    public ChunkedInputStream(Chunker chunker) {
        this.chunker = chunker;
    }

    @Override
    public void close() throws IOException {
        this.chunker.close();
        super.close();
    }

    @Override
    public int read() throws IOException {
        this.start();
        if (this.chunk == null) {
            return -1;
        }
        int c = ChunkedInputStream.unsignedByteToInt(this.chunk[this.pos]);
        ++this.pos;
        if (this.pos >= this.chunk.length) {
            this.chunk = this.advance();
            this.pos = 0;
        }
        return c;
    }

    @Override
    public int read(byte[] dest, int destOffset, int len) {
        int numRead = 0;
        if (dest == null) {
            throw new NullPointerException();
        }
        if (destOffset < 0 || len < 0 || len > dest.length - destOffset) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return 0;
        }
        this.start();
        if (this.chunk == null) {
            return -1;
        }
        int outstanding = len;
        while (outstanding > 0 && this.chunk != null) {
            int available = this.chunk.length - this.pos;
            int amt = Math.min(available, outstanding);
            System.arraycopy(this.chunk, this.pos, dest, destOffset + numRead, amt);
            outstanding -= amt;
            numRead += amt;
            this.pos += amt;
            if (this.pos < this.chunk.length) continue;
            this.chunk = this.advance();
            this.pos = 0;
        }
        return numRead;
    }

    protected static int chunkSize() {
        return 8192;
    }

    protected static int chunkSizeChars() {
        return 4096;
    }

    protected Chunker getChunker() {
        return this.chunker;
    }

    private byte[] advance() {
        byte[] chunk = null;
        while (chunk == null && this.chunker.hasNext()) {
            byte[] next = (byte[])this.chunker.next();
            if (next.length <= 0) continue;
            chunk = next;
        }
        return chunk;
    }

    private void start() {
        if (!this.started) {
            this.chunk = this.advance();
            this.started = true;
        }
    }

    private static int unsignedByteToInt(byte b) {
        return b & 0xFF;
    }

    public static interface Chunker
    extends Iterator<byte[]>,
    Closeable {
    }
}

