/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.util;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import oracle.dbtools.common.UnrecoverableException;

public class AtomicLoader<T> {
    private final Callable<T> loader;
    private final AtomicReference<T> value;

    public AtomicLoader(Callable<T> loader) {
        this.loader = loader;
        this.value = new AtomicReference();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        T value = this.value.get();
        if (value == null) {
            Callable<T> callable = this.loader;
            synchronized (callable) {
                block8: {
                    try {
                        T loaded = this.loader.call();
                        value = this.value.compareAndSet(null, loaded) ? loaded : this.value.get();
                    }
                    catch (RuntimeException e) {
                        value = this.value.get();
                        if (value == null) {
                            throw e;
                        }
                    }
                    catch (Exception e) {
                        value = this.value.get();
                        if (value != null) break block8;
                        throw UnrecoverableException.unrecoverable(e);
                    }
                }
            }
        }
        return value;
    }
}

