/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.uri;

import javax.inject.Inject;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import oracle.dbtools.common.uri.ContextPath;
import oracle.dbtools.common.uri.ContextPathImpl;
import oracle.dbtools.plugin.api.di.annotations.Provides;

@Provides
public class ContextPaths {
    private static final ContextPaths INSTANCE = new ContextPaths();

    @Inject
    public ContextPaths() {
    }

    public ContextPath contextPath(ServletContext ctx) {
        String path = ctx.getContextPath();
        return this.contextPath(path);
    }

    public ContextPath contextPath(ServletRequest request) {
        if (request instanceof HttpServletRequest) {
            String path = ((HttpServletRequest)request).getContextPath();
            return this.contextPath(path);
        }
        throw new IllegalArgumentException();
    }

    public ContextPath contextPath(String path) {
        if (path == null) {
            return null;
        }
        return new ContextPathImpl(path);
    }

    public static final ContextPaths instance() {
        return INSTANCE;
    }
}

