/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.ucp;

import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLRecoverableException;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import oracle.dbtools.common.concurrent.RetryStrategy;
import oracle.dbtools.common.errors.SQLExceptions;
import oracle.dbtools.common.ucp.ConnectionLabelingException;
import oracle.dbtools.common.ucp.Connections;
import oracle.dbtools.common.ucp.ForbiddenSchemaException;
import oracle.dbtools.common.util.Selector;
import oracle.dbtools.plugin.api.logging.Log;
import oracle.jdbc.OracleConnection;
import oracle.ucp.ConnectionLabelingCallback;
import oracle.ucp.jdbc.LabelableConnection;
import oracle.ucp.jdbc.ValidConnection;

class LabelingCallback
implements ConnectionLabelingCallback {
    private final Set<String> blackList;
    private final Connections connections;
    private final Log log;
    private final RetryStrategy retries;
    private static final int MAX_SESSIONS_EXCEEDED = 18;
    private static final RetryOnMaxSessions RETRYABLE_EXCEPTIONS = new RetryOnMaxSessions();

    LabelingCallback(Log log, Connections connections, RetryStrategy retries, Set<String> blackList) {
        this.log = log;
        this.connections = connections;
        this.retries = retries.modify().retryableExceptions(RETRYABLE_EXCEPTIONS).build();
        this.blackList = blackList;
    }

    public boolean configure(Properties requestedLabels, Object connection) {
        Connection conn = (Connection)connection;
        try {
            String schema = requestedLabels.getProperty("oracle.dbtools.jdbc.label.schema");
            if (this.isAllowed(schema)) {
                if (this.validateConnection(conn)) {
                    this.setContainer(conn, requestedLabels);
                    this.proxyToSchema(conn, requestedLabels);
                    this.disableAutoCommit(conn, requestedLabels);
                    return true;
                }
                this.connections.evict(conn);
                return false;
            }
            String url = this.connections.url(conn);
            this.connections.close(conn);
            throw new ConnectionLabelingException(ConnectionLabelingException.Phase.BLACKLIST, url, requestedLabels, new ForbiddenSchemaException(schema));
        }
        catch (ConnectionLabelingException e) {
            this.connections.close(conn);
            throw e;
        }
        catch (RuntimeException e) {
            this.log.warning((Throwable)e);
            this.connections.evict(conn);
            return false;
        }
    }

    public int cost(Properties requestedLabels, Properties currentLabels) {
        if (currentLabels.equals(requestedLabels)) {
            return 0;
        }
        return 10;
    }

    ConnectionLabelingException handle(ConnectionLabelingException.Phase phase, Connection conn, Properties labels, Throwable cause) {
        String url = this.connections.url(conn);
        if (cause instanceof SQLRecoverableException) {
            this.markInvalid(conn);
        }
        throw new ConnectionLabelingException(phase, url, labels, cause);
    }

    private void disableAutoCommit(Connection conn, Properties labels) {
        try {
            conn.setAutoCommit(false);
        }
        catch (SQLException e) {
            throw this.handle(ConnectionLabelingException.Phase.DISABLE_AUTO_COMMIT, conn, labels, e);
        }
    }

    private boolean isAllowed(String schema) {
        return schema == null ? true : !this.blackList.contains(schema.toUpperCase());
    }

    private void markInvalid(Connection conn) {
        Objects.requireNonNull(conn);
        try {
            if (conn instanceof ValidConnection) {
                ((ValidConnection)conn).setInvalid();
            }
        }
        catch (SQLException e) {
            this.log.fine((Throwable)e);
        }
    }

    private void proxyToSchema(Connection conn, Properties labels) {
        String schema = labels.getProperty("oracle.dbtools.jdbc.label.schema");
        if (conn instanceof OracleConnection && schema != null) {
            OracleConnection ora = (OracleConnection)conn;
            try {
                this.retries.execute(new ProxySchemaTask(schema, ora));
            }
            catch (Exception e) {
                this.connections.markInvalid(conn);
                throw this.handle(ConnectionLabelingException.Phase.PROXY_TO_SCHEMA, conn, labels, e);
            }
        }
    }

    private void setContainer(Connection conn, Properties labels) {
        String container = labels.getProperty("oracle.dbtools.jdbc.label.container");
        try {
            this.retries.execute(new SetContainerTask(container, conn));
        }
        catch (Exception e) {
            throw this.handle(ConnectionLabelingException.Phase.SET_CONTAINER, conn, labels, e);
        }
    }

    private boolean validateConnection(Connection conn) {
        try {
            Objects.requireNonNull(conn);
            return !conn.isClosed() && !this.connections.isProxied(conn);
        }
        catch (SQLException e) {
            return false;
        }
    }

    private final class SetContainerTask
    implements Callable<Void> {
        private final Connection conn;
        private final String container;

        private SetContainerTask(String container, Connection conn) {
            this.container = container;
            this.conn = conn;
        }

        @Override
        public Void call() throws Exception {
            LabelingCallback.this.connections.setContainer(this.conn, this.container);
            return null;
        }
    }

    private static final class RetryOnMaxSessions
    implements Selector<Throwable> {
        private RetryOnMaxSessions() {
        }

        @Override
        public Boolean apply(Throwable e) {
            int errorCode;
            if (e instanceof SQLException && 18 == (errorCode = SQLExceptions.getErrorCode((SQLException)e))) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
    }

    private final class ProxySchemaTask
    implements Callable<Void> {
        private final OracleConnection ora;
        private final String schema;

        private ProxySchemaTask(String schema, OracleConnection ora) {
            this.schema = schema;
            this.ora = ora;
        }

        @Override
        public Void call() throws Exception {
            Properties props = new Properties();
            props.setProperty("PROXY_USER_NAME", this.schema);
            this.ora.openProxySession(1, props);
            ((LabelableConnection)this.ora).applyConnectionLabel("oracle.dbtools.jdbc.label.schema", this.schema);
            return null;
        }
    }
}

