/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.timing;

import java.util.Objects;
import java.util.logging.Level;
import javax.inject.Inject;
import oracle.dbtools.common.timing.ExecutionTimerReport;
import oracle.dbtools.common.timing.ExecutionTimingEvent;
import oracle.dbtools.common.timing.TimingPoint;
import oracle.dbtools.common.util.Timestamps;
import oracle.dbtools.plugin.api.di.annotations.Provides;
import oracle.dbtools.plugin.api.logging.Log;

@Provides
public class LogTimerReport
implements ExecutionTimerReport {
    private final Log log;
    private static final int FINE_TIMING = Level.FINER.intValue();
    private static final int TIMING = Level.FINE.intValue();

    @Inject
    public LogTimerReport(Log log) {
        this.log = log;
    }

    @Override
    public ExecutionTimingEvent start(TimingPoint timingPoint) {
        Objects.requireNonNull(timingPoint);
        long start = this.now();
        return new LoggerTimingEvent(timingPoint, start);
    }

    private final long now() {
        return System.currentTimeMillis();
    }

    private class LoggerTimingEvent
    implements ExecutionTimingEvent {
        private final long start;
        private final TimingPoint timingPoint;

        private LoggerTimingEvent(TimingPoint timingPoint, long start) {
            Objects.requireNonNull(timingPoint);
            this.timingPoint = timingPoint;
            this.start = start;
        }

        @Override
        public long start() {
            return this.start;
        }

        @Override
        public long stop() {
            long duration = LogTimerReport.this.now() - this.start;
            String msg = "[TE] " + this.timingPoint + " start: " + Timestamps.toString(this.start) + " duration: " + duration + "ms";
            int level = this.timingPoint.level().intValue();
            if (level >= TIMING) {
                LogTimerReport.this.log.fine(msg);
            } else if (level < TIMING && level >= FINE_TIMING) {
                LogTimerReport.this.log.finer(msg);
            } else {
                LogTimerReport.this.log.finest(msg);
            }
            return duration;
        }

        @Override
        public TimingPoint timingPoint() {
            return this.timingPoint;
        }
    }
}

