/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.service;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

class __Reflections {
    __Reflections() {
    }

    public static Class<?> forName(String className) {
        if (className == null || className.isEmpty()) {
            return Void.class;
        }
        try {
            return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> annotationClass) {
        T annotation = null;
        for (Class<?> curr = clazz; curr != null && !curr.equals(Object.class) && (annotation = (T)curr.getAnnotation(annotationClass)) == null; curr = curr.getSuperclass()) {
        }
        return annotation;
    }

    public static <T extends Annotation> Field[] getFieldsAnnotatedWith(Class<?> clazz, Class<T> annotationClass) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> curr = clazz; curr != null && !curr.equals(Object.class); curr = curr.getSuperclass()) {
            Field[] current;
            for (Field field : current = curr.getDeclaredFields()) {
                if (field.getAnnotation(annotationClass) == null) continue;
                fields.add(field);
            }
        }
        return fields.toArray(new Field[fields.size()]);
    }

    static Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        Class<?> curr = clazz;
        Method m = null;
        while (m == null && curr != null && !curr.equals(Object.class)) {
            try {
                m = curr.getDeclaredMethod(name, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                curr = curr.getSuperclass();
            }
        }
        if (m == null) {
            throw new NoSuchMethodException(clazz.getName() + "." + name + __Reflections.argumentTypesToString(parameterTypes));
        }
        return m;
    }

    static Object invoke(Method m, Object instance, Object ... args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (m == null) {
            return null;
        }
        m.setAccessible(true);
        return m.invoke(instance, args);
    }

    private static String argumentTypesToString(Class<?>[] argTypes) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                Class<?> c;
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append((c = argTypes[i]) == null ? "null" : c.getName());
            }
        }
        buf.append(")");
        return buf.toString();
    }
}

