/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.service;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.common.service.ServiceLocator;

public final class ServiceProperties
implements Iterable<String> {
    private final Map<String, String> properties;

    ServiceProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public String get(String name) {
        return this.get(name, null);
    }

    public String get(String name, String defaultValue) {
        String value = this.properties.get(name);
        return value == null ? defaultValue : value;
    }

    public int getInt(String name) {
        return this.getInt(name, -1);
    }

    public int getInt(String name, int defaultValue) {
        String value = this.get(name, null);
        return value == null ? defaultValue : Integer.parseInt(value);
    }

    @Override
    public Iterator<String> iterator() {
        return this.keys().iterator();
    }

    public Set<String> keys() {
        return this.properties.keySet();
    }

    public static String get(Object impl, String name) {
        return ServiceLocator.properties(impl.getClass()).get(name);
    }
}

