/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.service;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.TreeSet;
import oracle.dbtools.common.service.Provider;
import oracle.dbtools.common.service.__Reflections;
import oracle.dbtools.common.service.model.Service;

class Providers {
    private final ArrayList<Provider> providers = new ArrayList();
    private final Class<?> provides;

    Providers(Class<?> provides) {
        this.provides = provides;
    }

    public void activateImmediates() {
        for (Provider p : this.providers) {
            p.activateIfImmediate();
        }
    }

    public void add(Provider provider) {
        this.providers.add(provider);
    }

    public <T> Iterable<T> match(Class<T> service, Map<String, String> properties) {
        TreeSet<T> matches = new TreeSet<T>(new Comparator<T>(){

            @Override
            public int compare(T o1, T o2) {
                Service s1 = __Reflections.getAnnotation(o1.getClass(), Service.class);
                Service s2 = __Reflections.getAnnotation(o2.getClass(), Service.class);
                int compare = s1.priority() - s2.priority();
                if (compare == 0) {
                    compare = o1.getClass().getCanonicalName().compareTo(o2.getClass().getCanonicalName());
                }
                return compare;
            }
        });
        for (Provider p : this.providers) {
            T impl = p.match(service, properties);
            if (impl == null) continue;
            matches.add(impl);
        }
        return matches.descendingSet();
    }

    public void teardown() {
        for (Provider p : this.providers) {
            p.deactivate();
        }
        this.providers.clear();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("{provides=");
        builder.append(this.provides);
        builder.append(", providers=");
        builder.append(this.providers);
        builder.append("}\n");
        return builder.toString();
    }
}

