/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.resources;

import java.net.URI;
import oracle.dbtools.common.builder.CanBuild;
import oracle.dbtools.common.resources.Resource;
import oracle.dbtools.common.resources.Resources;
import oracle.dbtools.common.uri.URISandbox;
import oracle.dbtools.common.util.URIs;

public class ResourcesContainer
implements Resources {
    private final URISandbox base;
    private final Resources resources;
    private static final URISandbox ROOT = URISandbox.sandbox(URIs.create("/"));

    private ResourcesContainer(URISandbox base, Resources resources) {
        this.base = base;
        this.resources = resources;
    }

    @Override
    public Resource get(Object key) {
        if (key == null) {
            throw new NullPointerException();
        }
        return this.get(key.toString());
    }

    @Override
    public Resource get(String path) {
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        Resource resource = null;
        URI uri = this.base.uri(path);
        if (uri != null) {
            resource = this.resources.get(uri.getPath());
        }
        return resource;
    }

    public Builder modify() {
        return new Builder(this);
    }

    public String toString() {
        StringBuilder builder2 = new StringBuilder();
        builder2.append("ResourcesContainer [base=");
        builder2.append(this.base);
        builder2.append(", resources=");
        builder2.append(this.resources);
        builder2.append("]");
        return builder2.toString();
    }

    public static Builder builder(Resources resources) {
        return new Builder(resources);
    }

    private static final URISandbox normalize(String path) {
        URI uri;
        if (path.charAt(path.length() - 1) != '/') {
            path = path + '/';
        }
        if ((uri = ROOT.uri(path)) == null) {
            throw new IllegalArgumentException(path);
        }
        return URISandbox.sandbox(uri);
    }

    public static class Builder
    implements CanBuild<ResourcesContainer> {
        private URISandbox base;
        private final Resources resources;

        protected Builder(Resources resources) {
            this.resources = resources;
        }

        public Builder base(String base) {
            this.base = ResourcesContainer.normalize(base);
            return this;
        }

        @Override
        public ResourcesContainer build() {
            return new ResourcesContainer(this.base, this.resources);
        }
    }
}

