/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.reflect;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AnnotatedElement;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import javax.lang.model.element.ElementKind;
import oracle.dbtools.common.util.Closeables;
import oracle.dbtools.common.util.Files;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.MultiAssociativeArray;
import oracle.dbtools.common.util.MultiAssociativeArrays;
import oracle.dbtools.common.util.NullOrEmpty;
import oracle.dbtools.common.util.StreamCopy;
import oracle.dbtools.common.util.URLEncoding;
import oracle.dbtools.plugin.api.logging.Log;

class AnnotatedElements {
    private final Log log;
    private final MultiAssociativeArray<String, AnnotationSite> annotatedElements;
    private final Iterable<File> roots;

    AnnotatedElements(Log log, ClassLoader parent, Iterable<String> superPackages, Iterable<String> validRoots) throws IOException {
        this.log = log;
        MultiAssociativeArrays.Builder<String, AnnotationSite> annotatedElements = MultiAssociativeArrays.builder();
        ArrayList<File> roots = new ArrayList<File>();
        for (String superPackage : superPackages) {
            String path = superPackage.replace('.', '/');
            Enumeration<URL> resources = parent.getResources(path);
            if (resources == null) continue;
            while (resources.hasMoreElements()) {
                File root;
                URL url = resources.nextElement();
                if (!url.getProtocol().equals("file") || !AnnotatedElements.isValidRoot(validRoots, root = AnnotatedElements.root(superPackage, URLEncoding.decode(url.getFile())))) continue;
                roots.add(root);
            }
        }
        this.roots = roots;
        FolderClassLoader cl = new FolderClassLoader(parent, superPackages, roots);
        for (File root : roots) {
            for (String superPackage : superPackages) {
                String path = superPackage.replace('.', '/');
                File pkgFolder = Files.file(root, path);
                if (!pkgFolder.exists()) continue;
                this.discoverAnnotatedElements(cl, annotatedElements, root, pkgFolder);
            }
        }
        this.annotatedElements = annotatedElements.build();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("AnnotatedElements [annotatedElements=");
        builder.append(this.annotatedElements);
        builder.append("]");
        return builder.toString();
    }

    Iterable<AnnotationSite> annotatedElements(String annotationType) {
        return this.annotatedElements.values(annotationType);
    }

    Iterable<String> annotationTypes() {
        return this.annotatedElements;
    }

    Iterable<File> roots() {
        return this.roots;
    }

    private void add(MultiAssociativeArrays.Builder<String, AnnotationSite> annotatedElements, AnnotatedElement element) {
        if (element != null) {
            ElementKind kind = ElementKind.CLASS;
            if (element instanceof Package) {
                kind = ElementKind.PACKAGE;
            }
            String name = null;
            if (element instanceof Package) {
                name = ((Package)element).getName();
            } else if (element instanceof Class) {
                name = ((Class)element).getName();
            }
            Object[] declaredAnnotations = element.getDeclaredAnnotations();
            if (NullOrEmpty.nullOrEmpty(declaredAnnotations)) {
                this.log.finest(name + " has no annotations");
            } else {
                this.log.finest(name + " is annotated with: " + Arrays.toString(declaredAnnotations));
            }
            for (Object annotation : declaredAnnotations) {
                annotatedElements.add(annotation.annotationType().getName(), new AnnotationSite(kind, name));
            }
        }
    }

    private void discoverAnnotatedElements(ClassLoader loader, MultiAssociativeArrays.Builder<String, AnnotationSite> annotatedElements, File root, File folder) {
        File[] children;
        for (File child : children = folder.listFiles()) {
            Class<?> type;
            if (child.isDirectory()) {
                this.discoverAnnotatedElements(loader, annotatedElements, root, child);
                continue;
            }
            if (!child.getName().endsWith(".class") || "package-info.class".equals(child.getName()) || (type = AnnotatedElements.clazz(loader, root, child)) == null) continue;
            this.add(annotatedElements, type);
        }
        Package pkg = this.pkg(loader, root, folder);
        this.add(annotatedElements, pkg);
    }

    private Package pkg(ClassLoader loader, File root, File child) {
        String rootPath = root.getAbsolutePath();
        String childPath = child.getAbsolutePath();
        String relativePath = childPath.substring(rootPath.length() + 1);
        String name = relativePath.substring(0, relativePath.length());
        String pkgName = name.replace(File.separatorChar, '.');
        return AnnotatedElements.getPackage(loader, pkgName);
    }

    private static Class<?> clazz(ClassLoader loader, File root, File child) {
        String rootPath = root.getAbsolutePath();
        String childPath = child.getAbsolutePath();
        String relativePath = childPath.substring(rootPath.length() + 1);
        String name = relativePath.substring(0, relativePath.length() - ".class".length());
        String className = name.replace(File.separatorChar, '.');
        try {
            return loader.loadClass(className);
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Package getPackage(ClassLoader loader, String pkgName) {
        PackageLoader pkgLoader = new PackageLoader(loader);
        Package pkg = pkgLoader.getPackage(pkgName);
        if (pkg == null) {
            pkg = pkgLoader.definePackage(pkgName);
        }
        return pkg;
    }

    private static boolean isValidRoot(Iterable<String> validRoots, File root) {
        if (NullOrEmpty.nullOrEmpty(validRoots)) {
            return true;
        }
        String name = root.getName();
        for (String validRoot : validRoots) {
            if (!validRoot.equals(name)) continue;
            return true;
        }
        return false;
    }

    private static File root(String packageName, String packagePath) {
        String path = packageName.replace('.', File.separatorChar);
        String base = packagePath.substring(0, packagePath.length() - path.length());
        return Files.file(base);
    }

    private static class PackageLoader
    extends ClassLoader {
        public PackageLoader(ClassLoader loader) {
            super(loader);
        }

        public Package definePackage(String pkgName) {
            return super.definePackage(pkgName, null, null, null, null, null, null, null);
        }

        @Override
        public Package getPackage(String name) {
            Package pkg = super.getPackage(name);
            return pkg;
        }
    }

    private static class FolderClassLoader
    extends ClassLoader {
        private final Iterable<String> packagePrefixes;
        private final Iterable<File> roots;

        public FolderClassLoader(ClassLoader parent, Iterable<String> packagePrefixes, Iterable<File> roots) {
            super(parent);
            if (NullOrEmpty.nullOrEmpty(roots)) {
                throw new IllegalArgumentException("No root directories specified");
            }
            this.roots = roots;
            this.packagePrefixes = packagePrefixes;
        }

        @Override
        protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
            Class<?> c = this.findLoadedClass(name);
            if (c == null) {
                boolean matchedPrefix = false;
                for (String packagePrefix : this.packagePrefixes) {
                    if (!name.startsWith(packagePrefix)) continue;
                    matchedPrefix = true;
                    break;
                }
                if (matchedPrefix) {
                    c = this.loadClassFromFolder(name);
                }
                if (c == null) {
                    c = this.findSystemClass(name);
                }
            }
            if (resolve) {
                this.resolveClass(c);
            }
            return c;
        }

        private File findFile(String filename) {
            for (File root : this.roots) {
                File f = Files.file(root, filename);
                if (!f.exists()) continue;
                return f;
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] loadClassData(String filename) throws IOException, ClassNotFoundException {
            File f = this.findFile(filename);
            if (f == null) {
                throw new ClassNotFoundException("Could not find file named: " + filename + " it does not exist within any of the following folders: " + Iterables.join(this.roots, ", "));
            }
            int size = (int)f.length();
            ByteArrayOutputStream bytes = new ByteArrayOutputStream(size);
            InputStream fis = null;
            try {
                fis = Files.inputStream(f);
                StreamCopy.drain(fis, bytes);
            }
            finally {
                Closeables.close(fis);
            }
            return bytes.toByteArray();
        }

        private Class<?> loadClassFromFolder(String name) throws ClassNotFoundException, ClassFormatError {
            Class<?> c = null;
            String filename = name.replace('.', File.separatorChar) + ".class";
            try {
                byte[] data = this.loadClassData(filename);
                c = this.defineClass(name, data, 0, data.length);
                if (c == null) {
                    throw new ClassNotFoundException(name);
                }
            }
            catch (IOException e) {
                throw new ClassNotFoundException("Error reading file: " + filename);
            }
            return c;
        }
    }

    static class AnnotationSite {
        private final ElementKind kind;
        private final String name;

        AnnotationSite(ElementKind kind, String name) {
            this.kind = kind;
            this.name = name;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            switch (this.kind) {
                case PACKAGE: {
                    builder.append("package ");
                    break;
                }
                default: {
                    builder.append("class ");
                }
            }
            builder.append(this.name);
            return builder.toString();
        }

        AnnotatedElement asAnnotatedElement(ClassLoader parent) {
            try {
                if (ElementKind.CLASS == this.kind) {
                    return parent.loadClass(this.name);
                }
                return AnnotatedElements.getPackage(parent, this.name);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException(e.getMessage());
            }
        }

        ElementKind kind() {
            return this.kind;
        }

        String name() {
            return this.name;
        }
    }
}

