/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.immutables.impl;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import oracle.dbtools.common.immutables.ImmutableMultiMap;
import oracle.dbtools.common.immutables.impl.CollectionFactory;
import oracle.dbtools.common.immutables.impl.MultiMapImpl;
import oracle.dbtools.common.util.KeyedLookup;
import oracle.dbtools.common.util.Ordering;
import oracle.dbtools.plugin.api.collections.MultiMap;

class MultiMapBuilder<K, V>
implements ImmutableMultiMap.Builder<K, V> {
    private Comparator<? super K> comparator = null;
    private final Collection<Map.Entry<K, V>> elements;
    private Ordering ordering = Ordering.INSERTION;

    private MultiMapBuilder(int size) {
        this.elements = CollectionFactory.list(size);
    }

    @Override
    public ImmutableMultiMap.Builder<K, V> add(K key, V value) {
        this.elements.add(new AbstractMap.SimpleEntry<K, V>(key, value));
        return this;
    }

    @Override
    public ImmutableMultiMap.Builder<K, V> add(KeyedLookup<? extends K, ? extends V> m) {
        for (Object key : m.keySet()) {
            Object value = m.get(key);
            this.add(key, value);
        }
        return this;
    }

    @Override
    public ImmutableMultiMap.Builder<K, V> add(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> entry : m.entrySet()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public ImmutableMultiMap.Builder<K, V> add(MultiMap<? extends K, ? extends V> m) {
        for (Map.Entry entry : m.entries()) {
            this.add(entry.getKey(), entry.getValue());
        }
        return this;
    }

    @Override
    public ImmutableMultiMap<K, V> build() {
        return MultiMapImpl.newInstance(this.elements, this.ordering, this.comparator);
    }

    @Override
    public ImmutableMultiMap.Builder<K, V> clear() {
        this.elements.clear();
        return this;
    }

    @Override
    public ImmutableMultiMap.Builder<K, V> comparator(Comparator<? super K> comparator) {
        this.comparator = comparator;
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MultiMapBuilder other = (MultiMapBuilder)obj;
        return !(this.elements == null ? other.elements != null : !this.elements.equals(other.elements));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.elements == null ? 0 : this.elements.hashCode());
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public ImmutableMultiMap.Builder<K, V> ordering(Ordering ordering) {
        this.ordering = ordering;
        return this;
    }

    @Override
    public ImmutableMultiMap.Builder<K, V> remove(Object key) {
        Iterator<Map.Entry<K, V>> iter = this.elements.iterator();
        while (iter.hasNext()) {
            Map.Entry<K, V> element = iter.next();
            if (!key.equals(element.getKey())) continue;
            iter.remove();
        }
        return this;
    }

    @Override
    public ImmutableMultiMap.Builder<K, V> remove(Object key, Object value) {
        Iterator<Map.Entry<K, V>> iter = this.elements.iterator();
        while (iter.hasNext()) {
            Map.Entry<K, V> element = iter.next();
            if (!key.equals(element.getKey()) || !value.equals(element.getValue())) continue;
            iter.remove();
        }
        return this;
    }

    @Override
    public ImmutableMultiMap.Builder<K, V> set(K key, V value) {
        Iterator<Map.Entry<K, V>> iter = this.elements.iterator();
        boolean replaced = false;
        while (iter.hasNext()) {
            Map.Entry<K, V> element = iter.next();
            K existing = element.getKey();
            if (!key.equals(existing)) continue;
            if (replaced) {
                iter.remove();
                continue;
            }
            element.setValue(value);
            replaced = true;
        }
        if (!replaced) {
            return this.add(key, value);
        }
        return this;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    public String toString() {
        return this.build().toString();
    }

    static <K, V> ImmutableMultiMap.Builder<K, V> newInstance(int size) {
        size = size == 0 ? 10 : (size *= 2);
        MultiMapBuilder<K, V> builder = new MultiMapBuilder<K, V>(size);
        return builder;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.build().containsKey(key);
    }
}

