/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.immutables.impl;

import java.util.Comparator;
import java.util.Map;
import oracle.dbtools.common.immutables.ImmutableMap;
import oracle.dbtools.common.immutables.impl.CollectionFactory;
import oracle.dbtools.common.immutables.impl.MapImpl;
import oracle.dbtools.common.util.KeyedLookup;
import oracle.dbtools.common.util.Ordering;

class MapBuilder<K, V>
implements ImmutableMap.Builder<K, V> {
    private Comparator<? super K> comparator = null;
    private final Map<K, V> elements;
    private Ordering ordering = Ordering.INSERTION;

    private MapBuilder(int size, Ordering ordering, Comparator<? super K> comparator) {
        this.elements = CollectionFactory.map(size, Ordering.INSERTION, null);
        this.ordering = ordering;
        this.comparator = comparator;
    }

    @Override
    public ImmutableMap.Builder<K, V> add(ImmutableMap<? extends K, ? extends V> m) {
        return this.add((Map<? extends K, ? extends V>)m);
    }

    @Override
    public ImmutableMap.Builder<K, V> add(K key, V value) {
        this.elements.put(key, value);
        return this;
    }

    @Override
    public ImmutableMap.Builder<K, V> add(KeyedLookup<? extends K, ? extends V> m) {
        for (Object key : m.keySet()) {
            Object value = m.get(key);
            this.elements.put(key, value);
        }
        return this;
    }

    @Override
    public ImmutableMap.Builder<K, V> add(Map<? extends K, ? extends V> m) {
        this.elements.putAll(m);
        return this;
    }

    @Override
    public ImmutableMap<K, V> build() {
        return MapImpl.newInstance(this.elements, this.ordering, this.comparator);
    }

    @Override
    public ImmutableMap.Builder<K, V> clear() {
        this.elements.clear();
        return this;
    }

    @Override
    public ImmutableMap.Builder<K, V> comparator(Comparator<? super K> comparator) {
        this.comparator = comparator;
        return this;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.elements.containsKey(key);
    }

    public boolean equals(Object obj) {
        return this.elements.equals(obj);
    }

    @Override
    public V get(Object key) {
        return this.elements.get(key);
    }

    public int hashCode() {
        return this.elements.hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.elements.isEmpty();
    }

    @Override
    public ImmutableMap.Builder<K, V> ordering(Ordering ordering) {
        this.ordering = ordering;
        return this;
    }

    @Override
    public ImmutableMap.Builder<K, V> remove(Object key) {
        this.elements.remove(key);
        return this;
    }

    @Override
    public int size() {
        return this.elements.size();
    }

    public String toString() {
        return this.elements.toString();
    }

    static <K, V> ImmutableMap.Builder<K, V> newInstance(int size, Ordering ordering, Comparator<? super K> comparator) {
        size = size == 0 ? 10 : (size *= 2);
        MapBuilder<? super K, V> builder = new MapBuilder<K, V>(size, ordering, comparator);
        return builder;
    }
}

