/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.immutables.impl;

import oracle.dbtools.common.di.Services;
import oracle.dbtools.common.immutables.Lists;
import oracle.dbtools.common.immutables.Maps;
import oracle.dbtools.common.immutables.MultiMaps;
import oracle.dbtools.common.immutables.Sets;
import oracle.dbtools.common.immutables.impl.ListsProvider;
import oracle.dbtools.common.immutables.impl.MapsProvider;
import oracle.dbtools.common.immutables.impl.MultiMapsProvider;
import oracle.dbtools.common.immutables.impl.SetsProvider;

public class ImmutablesProvider {
    private final Lists lists;
    private final Maps maps = new MapsProvider();
    private final MultiMaps multiMaps;
    private final Sets sets = new SetsProvider();
    private static final Class<?>[] PROVIDERS = new Class[]{MapsProvider.class, ListsProvider.class, SetsProvider.class, MultiMapsProvider.class};

    public ImmutablesProvider() {
        this.lists = new ListsProvider();
        this.multiMaps = new MultiMapsProvider();
    }

    public Lists lists() {
        return this.lists;
    }

    public Maps maps() {
        return this.maps;
    }

    public MultiMaps multiMaps() {
        return this.multiMaps;
    }

    public Sets sets() {
        return this.sets;
    }

    public static Services.Builder add(Services.Builder builder) {
        for (Class<?> provider : PROVIDERS) {
            builder.add(provider);
        }
        return builder;
    }

    public static Class<?>[] providers() {
        return PROVIDERS;
    }
}

