/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.headers;

import java.util.Iterator;
import oracle.dbtools.common.headers.QuotedStringScanner;
import oracle.dbtools.common.util.M2NIterator;

public class HttpHeaderSegmentParser
implements Iterable<String> {
    private final String delimiter;
    private final QuotedStringScanner scanner;

    public HttpHeaderSegmentParser(CharSequence text, String delimiter) {
        this.scanner = new QuotedStringScanner(text);
        this.delimiter = delimiter;
    }

    @Override
    public Iterator<String> iterator() {
        return new HttpHeaderSegmentIterator(this.scanner.iterator(), this.delimiter);
    }

    private static class HttpHeaderSegmentIterator
    extends M2NIterator<QuotedStringScanner.Token, String> {
        private final String delimiter;
        private StringBuilder segment = new StringBuilder();

        protected HttpHeaderSegmentIterator(Iterator<QuotedStringScanner.Token> src, String delimiter) {
            super(src);
            this.delimiter = delimiter;
        }

        @Override
        protected void finished() {
            if (this.segment.length() > 0) {
                this.pushSegment();
            }
        }

        @Override
        protected void process(QuotedStringScanner.Token token) {
            if (QuotedStringScanner.TokenType.TEXT == token.type()) {
                int start = 0;
                int end = -1;
                String text = token.content().toString();
                end = text.indexOf(this.delimiter, start);
                while (end != -1) {
                    this.segment.append(text.subSequence(start, end));
                    this.pushSegment();
                    this.segment = new StringBuilder();
                    start = end + 1;
                    end = text.indexOf(this.delimiter, start);
                }
                this.segment.append(token.subSequence(start, text.length()));
            } else {
                this.segment.append(token);
            }
        }

        private void pushSegment() {
            this.add(this.segment.toString());
        }
    }
}

