/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.graph;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.Iterator;
import oracle.dbtools.common.graph.Edge;
import oracle.dbtools.common.graph.EdgeChecker;
import oracle.dbtools.common.graph.TextRenderer;
import oracle.dbtools.common.graph.Vertex;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.MaybeEmpty;

public class Path<V, E>
implements MaybeEmpty {
    private final Deque<Edge<V, E>> edges;
    private final Vertex<V, E> start;
    private final int startIndex;
    private final TextRenderer<V, E> textRenderer;

    Path(int startIndex, Vertex<V, E> start, Deque<Edge<V, E>> edges, TextRenderer<V, E> textRenderer) {
        this.startIndex = startIndex;
        this.start = start;
        this.edges = edges;
        this.textRenderer = textRenderer;
    }

    public Iterable<E> edges() {
        ArrayList<E> values = new ArrayList<E>(this.edges.size());
        for (Edge<V, E> edge : Iterables.reverse(this.edges)) {
            values.add(edge.value());
        }
        return values;
    }

    public Vertex<V, E> end() {
        if (this.edges.size() > 0) {
            return this.edges.peek().destination();
        }
        return null;
    }

    public boolean equals(Object obj) {
        return this.toString().equals(obj.toString());
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    @Override
    public boolean isEmpty() {
        return this.edges.isEmpty();
    }

    public Builder<V, E> modify() {
        return new Builder(this);
    }

    public E peek() {
        if (this.edges.isEmpty()) {
            return null;
        }
        return this.edges.peek().value();
    }

    public Vertex<V, E> start() {
        return this.start;
    }

    public String toString() {
        StringBuilder b = new StringBuilder();
        TextRenderer.Renderer<V, E> renderer = this.textRenderer.using(b);
        V from = this.start.value();
        if (this.edges.isEmpty()) {
            renderer.render(from);
        } else {
            Iterator<Edge<V, E>> edges = this.edges.descendingIterator();
            while (edges.hasNext()) {
                Edge<V, E> edge = edges.next();
                V to = edge.destination().value();
                E using = edge.value();
                renderer.render(from, to, using);
                from = to;
            }
        }
        return renderer.done().toString();
    }

    boolean hasDirectCycle(EdgeChecker<V, E> edgeChecker) {
        int startCycleVertex;
        int n = startCycleVertex = this.edges.isEmpty() ? -1 : this.edges.peek().destinationIndex();
        if (startCycleVertex == -1) {
            return false;
        }
        boolean cycleStarted = false;
        if (this.startIndex == startCycleVertex) {
            cycleStarted = true;
        }
        Vertex<V, E> from = this.start;
        Iterator<Edge<V, E>> edges = this.edges.descendingIterator();
        while (edges.hasNext()) {
            Edge<V, E> using = edges.next();
            Vertex<V, E> to = using.destination();
            if (!cycleStarted && startCycleVertex == using.destinationIndex()) {
                cycleStarted = true;
            }
            if (cycleStarted) {
                boolean indirect;
                boolean bl = indirect = !edgeChecker.follow(from.value(), using.value(), to.value());
                if (indirect) {
                    return false;
                }
            }
            from = to;
        }
        return true;
    }

    public static class Builder<V, E> {
        private final Deque<Edge<V, E>> edges = new ArrayDeque<Edge<V, E>>();
        private final Vertex<V, E> start;
        private final int startIndex;
        private final TextRenderer<V, E> textRenderer;

        Builder(int startIndex, Vertex<V, E> start, TextRenderer<V, E> textRenderer) {
            this.startIndex = startIndex;
            this.start = start;
            this.textRenderer = textRenderer;
        }

        Builder(Path<V, E> existing) {
            this(((Path)existing).startIndex, ((Path)existing).start, ((Path)existing).textRenderer);
            this.edges.addAll(((Path)existing).edges);
        }

        public Path<V, E> build() {
            ArrayDeque<Edge<V, E>> edges = new ArrayDeque<Edge<V, E>>(this.edges);
            return new Path<V, E>(this.startIndex, this.start, edges, this.textRenderer);
        }

        public boolean contains(V value) {
            if (this.start.value().equals(value)) {
                return true;
            }
            for (Edge<V, E> edge : this.edges) {
                if (!edge.destination().value().equals(value)) continue;
                return true;
            }
            return false;
        }

        public Builder<V, E> pop() {
            this.edges.pop();
            return this;
        }

        public Builder<V, E> push(E value) {
            Vertex<V, E> end = this.start;
            if (this.edges.size() > 0) {
                end = this.peek().destination();
            }
            boolean found = false;
            for (Edge<V, E> edge : end.edges()) {
                if (!edge.value().equals(value)) continue;
                found = true;
                this.edges.push(edge);
                break;
            }
            if (!found) {
                throw new IllegalArgumentException(value + " is not an edge of: " + end.value());
            }
            return this;
        }

        public Builder<V, E> push(Edge<V, E> edge) {
            Vertex<V, E> end = this.start;
            if (this.edges.size() > 0) {
                end = this.peek().destination();
            }
            if (!end.edges().contains(edge)) {
                throw new IllegalArgumentException();
            }
            this.edges.push(edge);
            return this;
        }

        public String toString() {
            return this.build().toString();
        }

        private Edge<V, E> peek() {
            return this.edges.peek();
        }
    }
}

