/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.graph;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import oracle.dbtools.common.util.HasSize;
import oracle.dbtools.common.util.Iterables;

public class AdjacencyListsGraph<V, E>
implements HasSize {
    private final Vertex<V, E>[] vertices;
    private static final byte BLACK = 2;
    private static final byte GREY = 1;
    private static final byte WHITE = 0;

    public AdjacencyListsGraph(Collection<? extends Vertex<V, E>> vertices) {
        this.vertices = vertices.toArray(new Vertex[vertices.size()]);
    }

    public void depthFirstTraversal(int startVertex, Visitor<V, E> visitor) {
        byte[] visited = new byte[this.size()];
        ArrayDeque<Level<V, E>> levels = new ArrayDeque<Level<V, E>>(this.size());
        levels.push(this.level(startVertex));
        visited[startVertex] = 1;
        while (!levels.isEmpty()) {
            byte colour;
            Level currentLevel = (Level)levels.peek();
            if (currentLevel.isEmpty()) {
                Level completed = (Level)levels.pop();
                colour = visited[completed.index];
                if (1 != colour) continue;
                visited[completed.index] = 2;
                visitor.visit(completed.index, completed.vertex);
                continue;
            }
            int target = currentLevel.pop();
            colour = visited[target];
            if (colour == 0) {
                visited[target] = 1;
                levels.push(this.level(target));
                continue;
            }
            int[] path = new int[levels.size()];
            int i = 0;
            for (Level predecessor : Iterables.reverse(levels)) {
                path[i] = predecessor.index;
                ++i;
            }
            if (visitor.cycle(path)) continue;
            return;
        }
    }

    @Override
    public boolean isEmpty() {
        return this.vertices.length == 0;
    }

    @Override
    public int size() {
        return this.vertices.length;
    }

    public Vertex<V, E> vertex(int vertexIndex) {
        if (vertexIndex < 0 || vertexIndex >= this.vertices.length) {
            throw new ArrayIndexOutOfBoundsException(vertexIndex);
        }
        return this.vertices[vertexIndex];
    }

    private final Level<V, E> level(int index) {
        Vertex<V, E> vertex = this.vertex(index);
        Level<V, E> level = new Level<V, E>(index, vertex);
        return level;
    }

    private static class Level<V, E> {
        final int index;
        final Vertex<V, E> vertex;
        private final Deque<Integer> targets;

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Level [index=");
            builder.append(this.index);
            builder.append(", vertex=");
            builder.append(this.vertex);
            builder.append(", targets=");
            builder.append(this.targets);
            builder.append("]");
            return builder.toString();
        }

        Level(int vertexIndex, Vertex<V, E> vertex) {
            this.index = vertexIndex;
            this.vertex = vertex;
            Collection<Edge<E>> edges = vertex.edges();
            this.targets = new ArrayDeque<Integer>(edges.size());
            for (Edge<E> edge : edges) {
                this.targets.add(edge.targetVertexIndex);
            }
        }

        boolean isEmpty() {
            return this.targets.isEmpty();
        }

        int pop() {
            return this.targets.pop();
        }
    }

    private static class Adjacents<V, E>
    implements Vertex<V, E> {
        private final List<Edge<E>> edges;
        private final V value;

        private Adjacents(V value) {
            this.value = value;
            this.edges = new ArrayList<Edge<E>>();
        }

        @Override
        public Collection<Edge<E>> edges() {
            return this.edges;
        }

        @Override
        public V value() {
            return this.value;
        }

        Adjacents<V, E> add(E edge, int targetVertex) {
            this.edges.add(new Edge(targetVertex, edge));
            return this;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Adjacents [edges=");
            builder.append(this.edges);
            builder.append(", value=");
            builder.append(this.value);
            builder.append("]");
            return builder.toString();
        }
    }

    public static interface Visitor<V, E> {
        public void visit(int var1, Vertex<V, E> var2);

        public boolean cycle(int[] var1);
    }

    public static interface Vertex<V, E> {
        public Collection<Edge<E>> edges();

        public V value();
    }

    public static final class Edge<E> {
        public final E edge;
        public final int targetVertexIndex;

        private Edge(int targetVertexIndex, E edge) {
            this.targetVertexIndex = targetVertexIndex;
            this.edge = edge;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            builder.append("Edge [edge=");
            builder.append(this.edge);
            builder.append(", targetVertexIndex=");
            builder.append(this.targetVertexIndex);
            builder.append("]");
            return builder.toString();
        }
    }

    public static class Builder<V, E> {
        private final List<Adjacents<V, E>> adj = new ArrayList<Adjacents<V, E>>();
        private final Map<V, Integer> indexes = new LinkedHashMap<V, Integer>();
        private int vertexCount = 0;

        AdjacencyListsGraph<V, E> build() {
            return new AdjacencyListsGraph<V, E>(this.adj);
        }

        Builder<V, E> connect(V from, V to, E using) {
            int f = this.index(from);
            int t = this.index(to);
            this.add(f, t, using);
            return this;
        }

        private void add(int f, int t, E via) {
            Adjacents<V, E> from = this.adj.get(f);
            from.add(via, t);
        }

        private int index(V vertex) {
            Integer existing = this.indexes.get(vertex);
            if (existing == null) {
                int index = this.vertexCount++;
                this.adj.add(new Adjacents(vertex));
                this.indexes.put((Integer)vertex, index);
                return index;
            }
            return existing;
        }
    }
}

