/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.diagnostics;

import javax.servlet.http.HttpServletRequest;
import oracle.dbtools.common.config.GlobalConfiguration;
import oracle.dbtools.common.diagnostics.DiagnosticContext;
import oracle.dbtools.common.diagnostics.DiagnosticContextImpl;
import oracle.dbtools.common.diagnostics.DiagnosticOutput;
import oracle.dbtools.common.diagnostics.DiagnosticPageOutput;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.util.PrimitiveTypes;

@Service
public class Diagnostics {
    @Deprecated
    public static final String DEBUG_DEBUGGER = "debug.debugger";
    public static final String DEBUG_OUTPUT = "debug.output";
    public static final String DEBUG_PRINTDEBUGTOSCREEN = "debug.printDebugToScreen";
    private static final String DIAGNOSTIC_CONTEXT = "apex.diagnostic.context";

    public DiagnosticContext diagnosticContext(HttpServletRequest request) {
        return this.diagnosticContext(request, false);
    }

    public DiagnosticContext diagnosticContext(HttpServletRequest request, boolean create) {
        DiagnosticContext ctx = (DiagnosticContext)request.getAttribute(DIAGNOSTIC_CONTEXT);
        if (ctx == null) {
            if (create) {
                ctx = new DiagnosticContextImpl(this.outputStatus(request), this.pageOutputStatus());
                request.setAttribute(DIAGNOSTIC_CONTEXT, (Object)ctx);
            } else {
                throw new IllegalStateException();
            }
        }
        return ctx;
    }

    private DiagnosticOutput outputStatus(HttpServletRequest req) {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.globalConfiguration();
        DiagnosticOutput output = DiagnosticOutput.parse(globalConfiguration.get(DEBUG_OUTPUT));
        if (null == output) {
            String debugger = globalConfiguration.get(DEBUG_DEBUGGER);
            if (debugger != null) {
                boolean enabled = PrimitiveTypes.valueOf(debugger, Boolean.class);
                output = enabled ? DiagnosticOutput.CONSOLE : DiagnosticOutput.LOGGER;
            } else {
                boolean apexDebuggingEnabled = this.apexDebugEnabled(req);
                if (apexDebuggingEnabled) {
                    output = DiagnosticOutput.CONSOLE;
                }
            }
        }
        if (output == null) {
            output = DiagnosticOutput.LOGGER;
        }
        return output;
    }

    private DiagnosticPageOutput pageOutputStatus() {
        GlobalConfiguration globalConfiguration = GlobalConfiguration.globalConfiguration();
        DiagnosticPageOutput output = DiagnosticPageOutput.parse(globalConfiguration.get(DEBUG_PRINTDEBUGTOSCREEN));
        return output;
    }

    private boolean apexDebugEnabled(HttpServletRequest req) {
        return req.getQueryString() != null && req.getQueryString().indexOf(":YES:") > 0;
    }
}

