/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.di;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;

class __Reflections {
    __Reflections() {
    }

    static Class<?> forName(String className) {
        if (className == null || className.isEmpty()) {
            return Void.class;
        }
        try {
            return Class.forName(className, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    static <T extends Annotation> T getAnnotation(Class<?> clazz, Class<T> annotationClass) {
        T annotation = null;
        for (Class<?> curr = clazz; curr != null && !curr.equals(Object.class) && (annotation = (T)curr.getAnnotation(annotationClass)) == null; curr = curr.getSuperclass()) {
        }
        return annotation;
    }

    static <T extends Annotation> Constructor<?>[] getConstructorsAnnotatedWith(Class<?> type, Class<T> annotationType) {
        ArrayList constructors = new ArrayList();
        AnnotatedElement[] current = type.getDeclaredConstructors();
        __Reflections.addElementsAnnotatedWith((AnnotatedElement[])current, constructors, annotationType);
        return constructors.toArray(new Constructor[constructors.size()]);
    }

    static <T extends Annotation> Field[] getFieldsAnnotatedWith(Class<?> clazz, Class<T> annotationClass) {
        ArrayList fields = new ArrayList();
        for (Class<?> curr = clazz; curr != null && !curr.equals(Object.class); curr = curr.getSuperclass()) {
            AnnotatedElement[] current = curr.getDeclaredFields();
            __Reflections.addElementsAnnotatedWith((AnnotatedElement[])current, fields, annotationClass);
        }
        return fields.toArray(new Field[fields.size()]);
    }

    static Method getMethod(Class<?> clazz, String name, Class<?> ... parameterTypes) throws NoSuchMethodException {
        if (clazz == null || name == null) {
            throw new NullPointerException();
        }
        Class<?> curr = clazz;
        Method m = null;
        while (m == null && curr != null && !curr.equals(Object.class)) {
            try {
                m = curr.getDeclaredMethod(name, parameterTypes);
            }
            catch (NoSuchMethodException e) {
                curr = curr.getSuperclass();
            }
        }
        if (m == null) {
            throw new NoSuchMethodException(clazz.getName() + "." + name + __Reflections.argumentTypesToString(parameterTypes));
        }
        return m;
    }

    static <T extends Annotation> Method[] getMethodsAnnotatedWith(Class<?> type, Class<T> annotationType) {
        ArrayList methods = new ArrayList();
        for (Class<?> curr = type; curr != null && !curr.equals(Object.class); curr = curr.getSuperclass()) {
            AnnotatedElement[] current = curr.getDeclaredMethods();
            __Reflections.addElementsAnnotatedWith((AnnotatedElement[])current, methods, annotationType);
        }
        return methods.toArray(new Method[methods.size()]);
    }

    static Object invoke(Method m, Object instance, Object ... args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        if (m == null) {
            return null;
        }
        m.setAccessible(true);
        return m.invoke(instance, args);
    }

    private static <T extends AnnotatedElement, A extends Annotation> void addElementsAnnotatedWith(T[] elements, Collection<T> matches, Class<A> annotationType) {
        for (A element : elements) {
            if (element.getAnnotation(annotationType) == null) continue;
            matches.add(element);
        }
    }

    private static String argumentTypesToString(Class<?>[] argTypes) {
        StringBuilder buf = new StringBuilder();
        buf.append("(");
        if (argTypes != null) {
            for (int i = 0; i < argTypes.length; ++i) {
                Class<?> c;
                if (i > 0) {
                    buf.append(", ");
                }
                buf.append((c = argTypes[i]) == null ? "null" : c.getName());
            }
        }
        buf.append(")");
        return buf.toString();
    }
}

