/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.builder;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import oracle.dbtools.common.builder.Version;
import oracle.dbtools.common.builder.Versioned;

public class Versions {
    private final ConcurrentMap<Class<?>, AtomicLong> instanceCounts = new ConcurrentHashMap();

    public Version firstVersion(Class<?> type) {
        if (type == null) {
            throw new IllegalArgumentException();
        }
        AtomicLong count = (AtomicLong)this.instanceCounts.get(type);
        if (count == null) {
            count = new AtomicLong();
            this.instanceCounts.putIfAbsent(type, count);
        }
        long value = count.incrementAndGet();
        return new Version(type, null, value);
    }

    public Version newVersion(Versioned existing) {
        Version existingVersion = existing.version();
        Version newVersion = existingVersion.child();
        return newVersion;
    }

    public void reset() {
        this.instanceCounts.clear();
    }
}

