/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.buffers;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import oracle.dbtools.common.buffers.BufferHandle;
import oracle.dbtools.common.buffers.Buffers;
import oracle.dbtools.common.buffers.DiskHandle;
import oracle.dbtools.common.buffers.StreamBuffer;
import oracle.dbtools.common.util.Files;

class DiskBuffer
implements StreamBuffer {
    File file;

    DiskBuffer() {
    }

    @Override
    public BufferHandle acquire() {
        if (this.file == null) {
            throw new IllegalStateException("No buffer yet created");
        }
        return new DiskHandle(this.file);
    }

    @Override
    public OutputStream open() throws IOException {
        this.file = Buffers.tempFile();
        return new BufferedOutputStream(Files.outputStream(this.file), 4096);
    }

    public String toString() {
        if (this.file == null) {
            return "";
        }
        return this.file.getPath();
    }
}

