/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.common.aliasing;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import oracle.dbtools.common.aliasing.Aliasable;
import oracle.dbtools.common.config.GlobalConfiguration;
import oracle.dbtools.common.immutables.ImmutableMap;
import oracle.dbtools.common.immutables.Immutables;
import oracle.dbtools.common.util.PrimitiveTypes;

public final class AliasingGenerator {
    public static final AliasingCase DEFACTOCASE = AliasingCase.LOWERCASE;
    public static final AliasingCase DEFAULTCASE = AliasingGenerator.getDefautAliasingCase();
    public static final Locale DEFAULTLOCALE = Locale.ROOT;
    public static final GenerationResult NAME2ALIASING = GenerationResult.NAME2ALIASING;
    public static final GenerationResult ALIASING2NAME = GenerationResult.ALIASING2NAME;
    public static final AliasingGenerator ALIASINGGENERATOR = AliasingGenerator.build();
    private final Locale locale;
    private final AliasingCase aliasingCase;

    private AliasingGenerator(Locale locale, AliasingCase aliasingCase) {
        this.locale = locale;
        this.aliasingCase = aliasingCase;
    }

    public static AliasingGenerator build(Locale locale, AliasingCase aliasingCase) {
        return new AliasingGenerator(locale != null ? locale : DEFAULTLOCALE, aliasingCase != null ? aliasingCase : DEFAULTCASE);
    }

    public static AliasingGenerator build(Locale locale) {
        return AliasingGenerator.build(locale, null);
    }

    public static AliasingGenerator build(AliasingCase aliasingCase) {
        return AliasingGenerator.build(null, aliasingCase);
    }

    public static AliasingGenerator build() {
        return AliasingGenerator.build(null, null);
    }

    private static AliasingCase getDefautAliasingCase() {
        String caseValue = PrimitiveTypes.valueOf(GlobalConfiguration.globalConfiguration().get("misc.aliasing.case", DEFACTOCASE.name()), String.class);
        try {
            return AliasingCase.valueOf(caseValue);
        }
        catch (Exception e) {
            return DEFACTOCASE;
        }
    }

    private AliasingCase getAliasingCase() {
        return this.aliasingCase;
    }

    public ImmutableMap<String, String> generateNameAliasings(GenerationResult resultType, Iterable<String> nameCollection) {
        if (nameCollection == null) {
            return null;
        }
        HashMap<String, String> namedAliasingMap = new HashMap<String, String>();
        for (String name : nameCollection) {
            namedAliasingMap.put(name, null);
        }
        return this.generateAliasings(resultType, namedAliasingMap);
    }

    public ImmutableMap<String, String> generateAliasings(GenerationResult resultType, Iterable<? extends Aliasable> aliasableCollection) {
        if (aliasableCollection == null) {
            return null;
        }
        HashMap<String, String> namedAliasingMap = new HashMap<String, String>();
        for (Aliasable aliasable : aliasableCollection) {
            namedAliasingMap.put(aliasable.name(), aliasable.aliasing());
        }
        return this.generateAliasings(resultType, namedAliasingMap);
    }

    public ImmutableMap<String, String> generateAliasings(GenerationResult resultType, Map<String, String> namedAliasingMap) {
        if (namedAliasingMap == null) {
            return null;
        }
        Map<String, String> aliasedNameMap = this.generateAliasings(namedAliasingMap);
        ImmutableMap.Builder<String, String> ret = Immutables.maps().builder();
        switch (resultType) {
            case NAME2ALIASING: {
                for (Map.Entry<String, String> entry : aliasedNameMap.entrySet()) {
                    ret.add(entry.getValue(), entry.getKey());
                }
                break;
            }
            case ALIASING2NAME: {
                ret.add(aliasedNameMap);
            }
        }
        return ret.build();
    }

    public static String getAlias(Map<String, String> namedAliasingMap, String name) {
        String aliasing = namedAliasingMap != null ? namedAliasingMap.get(name) : null;
        return aliasing != null ? aliasing : name;
    }

    public String getAlias(String name) {
        return this.getAliasingCase().toCase(name, this.locale);
    }

    public static String getName(Map<String, String> aliasingNameMap, String aliasing) {
        String name = aliasingNameMap != null ? aliasingNameMap.get(aliasing) : null;
        return name != null ? name : aliasing;
    }

    private Map<String, String> generateAliasings(Map<String, String> namedAliasingMap) {
        return new AliasingGeneratorTask(namedAliasingMap, this.getAliasingCase()).generateAliasings();
    }

    private final class AliasingGeneratorTask {
        private final Map<String, String> aliasedNameMap;
        private final LinkedHashSet<String> overloaded;
        private final Map<String, String> namedAliasingMap;
        private final AliasingCase aliasingCase;

        private AliasingGeneratorTask(Map<String, String> namedAliasingMap, AliasingCase aliasingCase) {
            this.namedAliasingMap = namedAliasingMap;
            this.aliasedNameMap = new HashMap<String, String>();
            this.overloaded = new LinkedHashSet();
            this.aliasingCase = aliasingCase;
        }

        private Map<String, String> generateAliasings() {
            String name;
            Set<Map.Entry<String, String>> entrySet = this.namedAliasingMap.entrySet();
            for (Map.Entry<String, String> entry : entrySet) {
                name = entry.getKey();
                if (entry.getValue() != null) continue;
                String aliasing = this.generateAliasing(name);
                this.putAliasing(aliasing, name, AliasingOrigin.GENERATED);
            }
            for (Map.Entry<String, String> entry : entrySet) {
                String aliasing = entry.getValue();
                if (aliasing == null) continue;
                String name2 = entry.getKey();
                this.putAliasing(aliasing, name2, AliasingOrigin.EXPLICIT);
            }
            for (String aliasing : this.overloaded) {
                String explicitAliasing;
                if (!this.aliasedNameMap.containsKey(aliasing) || (explicitAliasing = this.namedAliasingMap.get(name = this.aliasedNameMap.get(aliasing))) == aliasing) continue;
                this.aliasedNameMap.remove(aliasing);
                this.putAliasing(name, name, AliasingOrigin.MANDATED);
            }
            return this.aliasedNameMap;
        }

        private void putAliasing(String aliasing, String name, AliasingOrigin origin) {
            String original = this.aliasedNameMap.put(aliasing, name);
            if (original != null) {
                int nameSuitability = this.compareAliasingNames(aliasing, name, original, origin);
                if (nameSuitability < 0) {
                    this.aliasedNameMap.put(aliasing, original);
                    this.overloaded.remove(aliasing);
                    this.putAliasing(name, name, AliasingOrigin.MANDATED);
                } else if (nameSuitability == 0) {
                    this.aliasedNameMap.put(aliasing, original);
                    this.overloaded.add(aliasing);
                    this.putAliasing(name, name, AliasingOrigin.MANDATED);
                } else {
                    this.putAliasing(original, original, AliasingOrigin.MANDATED);
                    this.overloaded.remove(aliasing);
                }
            }
        }

        private int compareAliasingNames(String aliasing, String candidate, String original, AliasingOrigin origin) {
            switch (origin) {
                case MANDATED: {
                    return 1;
                }
                case EXPLICIT: {
                    return -1;
                }
            }
            if (aliasing == null) {
                return -1;
            }
            if (aliasing.equals(original)) {
                return -1;
            }
            if (aliasing.equals(candidate)) {
                return 1;
            }
            if (this.isYang(original)) {
                return -1;
            }
            if (this.isYang(candidate)) {
                return 1;
            }
            return 0;
        }

        private String generateAliasing(String name) {
            return this.aliasingCase.toCase(name, AliasingGenerator.this.locale);
        }

        private boolean isYang(String name) {
            return this.aliasingCase.ying() != this.aliasingCase.yang() && this.aliasingCase.yang().isCase(name);
        }
    }

    private static enum GenerationResult {
        NAME2ALIASING,
        ALIASING2NAME;

    }

    private static enum AliasingOrigin {
        GENERATED,
        EXPLICIT,
        MANDATED;

    }

    public static enum AliasingCase {
        LOWERCASE,
        UPPERCASE,
        ANYCASE;


        public boolean isCase(String s) {
            switch (this) {
                case LOWERCASE: {
                    return AliasingCase.isLowerCase(s);
                }
                case UPPERCASE: {
                    return AliasingCase.isUpperCase(s);
                }
            }
            return true;
        }

        private static boolean isUpperCase(String s) {
            boolean hasUpper = false;
            if (s != null) {
                for (int i = 0; i < s.length(); ++i) {
                    char cp = s.charAt(i);
                    if (!Character.isLetter((int)cp)) continue;
                    if (Character.isLowerCase((int)cp)) {
                        return false;
                    }
                    if (hasUpper || !Character.isUpperCase((int)cp)) continue;
                    hasUpper = true;
                }
            }
            return hasUpper;
        }

        private static boolean isLowerCase(String s) {
            boolean hasLower = false;
            if (s != null) {
                for (int i = 0; i < s.length(); ++i) {
                    char cp = s.charAt(i);
                    if (!Character.isLetter((int)cp)) continue;
                    if (Character.isUpperCase((int)cp)) {
                        return false;
                    }
                    if (hasLower || !Character.isLowerCase((int)cp)) continue;
                    hasLower = true;
                }
            }
            return hasLower;
        }

        public String toCase(String s, Locale locale) {
            if (s != null) {
                switch (this) {
                    case LOWERCASE: {
                        return s.toLowerCase(locale);
                    }
                    case UPPERCASE: {
                        return s.toUpperCase(locale);
                    }
                }
                return s;
            }
            return s;
        }

        public AliasingCase yang() {
            switch (this) {
                case LOWERCASE: {
                    return UPPERCASE;
                }
                case UPPERCASE: {
                    return LOWERCASE;
                }
            }
            return ANYCASE;
        }

        public AliasingCase ying() {
            return this;
        }
    }
}

