/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.share.perf;

import oracle.adf.share.logging.ADFLogger;
import oracle.dms.instrument.DMSConsole;
import oracle.dms.instrument.Noun;
import oracle.dms.instrument.SegregationType;

class NounUtil {
    private NounUtil() {
    }

    static Noun registerGroupNameIfNeeded(String groupName, SegregationType sgType, String type) {
        Noun parentNoun = Noun.get((String)groupName, (SegregationType)sgType);
        if (parentNoun == null) {
            if (type == null || type.trim().length() == 0) {
                parentNoun = Noun.create((String)groupName, (SegregationType)sgType);
            } else {
                type = type.trim();
                if (!SegregationType.NONE.equals((Object)sgType)) {
                    DMSConsole.getConsole().getNounTypeManager().registerNounTypeSegregation(sgType, new String[]{type});
                }
                parentNoun = Noun.create((String)groupName, (SegregationType)sgType);
                parentNoun.setType(type);
            }
        } else {
            type = type != null ? type.trim() : type;
            String parentType = parentNoun.getType();
            if (parentType == null || "n/a".equals(parentType)) {
                parentNoun.setType(type);
            } else if (!parentType.equals(type) && LazyLogger.INST.isInfo()) {
                LazyLogger.INST.info(type + " type being ignored with insufficient uniqueness in " + groupName + " (" + parentType + ")");
            }
        }
        return parentNoun;
    }

    private static class LazyLogger {
        static final ADFLogger INST = ADFLogger.createADFLogger("oracle.adfinternal.share.perf.NounUtil");

        private LazyLogger() {
        }
    }
}

