/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.share.objectmerge.logging;

import java.util.Date;
import oracle.adfinternal.share.objectmerge.logging.SandboxLogRecord;

public abstract class AbstractChangeRecord<R extends AbstractChangeRecord<R>>
extends SandboxLogRecord<R> {
    protected final String objectName;
    protected final String objectType;

    protected AbstractChangeRecord(String objName, String objType, String summary) {
        super(summary);
        if (objName == null) {
            throw new IllegalArgumentException("Invalid object name: null.");
        }
        if (objType == null) {
            throw new IllegalArgumentException("Invalid object type: null.");
        }
        this.objectName = objName;
        this.objectType = objType;
    }

    @Override
    public String toString() {
        return "[" + this.objectName + "][" + this.objectType + "] " + super.toString();
    }

    public R changeType(ChangeType t) {
        return (R)((AbstractChangeRecord)this.put("changeType", (Object)t));
    }

    public R changeDate(Date d) {
        return (R)((AbstractChangeRecord)this.put("changeDate", d));
    }

    public R changedBy(String s) {
        return (R)((AbstractChangeRecord)this.put("changedBy", s));
    }

    public R repositoryId(String s) {
        return (R)((AbstractChangeRecord)this.put("repositoryId", s));
    }

    public R featureId(String s) {
        return (R)((AbstractChangeRecord)this.put("featureId", s));
    }

    public R url(String s) {
        return (R)((AbstractChangeRecord)this.put("url", s));
    }

    public static enum ChangeType {
        ADDED,
        REMOVED,
        MODIFIED;

    }
}

