/*
 * Decompiled with CFR 0.152.
 */
package oracle.adfinternal.share.dump;

import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Logger;
import oracle.adf.share.common.ClassUtils;
import oracle.adfinternal.share.release.ReleaseAdapter;

public class DumpImpl {
    private static final Logger logger = Logger.getLogger(DumpImpl.class.getName());
    private static final WeakReference<Method> methRef = new WeakReference<Object>(null);
    private static final AtomicBoolean reportedOnce = new AtomicBoolean(false);

    private DumpImpl() {
    }

    private static void reportExceptions(Exception e, Exception f) {
        if (reportedOnce.compareAndSet(false, true)) {
            ReleaseAdapter.getInstance().reportException(logger, e, f);
        }
    }

    public static void createIncident(Exception e) {
        Method m = (Method)methRef.get();
        if (m == null) {
            if (reportedOnce.get()) {
                return;
            }
            try {
                m = ClassUtils.forName("oracle.adf.share.dfw.dump.ADFDumpUtility", DumpImpl.class).getDeclaredMethod("createIncident", Exception.class);
            }
            catch (ClassNotFoundException f) {
                DumpImpl.reportExceptions(e, f);
                return;
            }
            catch (NoSuchMethodException f) {
                DumpImpl.reportExceptions(e, f);
                return;
            }
        }
        try {
            m.invoke(null, e);
        }
        catch (IllegalAccessException f) {
            DumpImpl.reportExceptions(e, f);
        }
        catch (InvocationTargetException f) {
            DumpImpl.reportExceptions(e, f);
        }
    }
}

