/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.services;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.adf.share.common.ClassUtils;
import oracle.adf.share.services.DescriptorContext;
import oracle.adf.share.services.DescriptorContextFactory;
import oracle.adf.share.services.ResourceServiceStrategy;
import oracle.adf.share.services.ServicePlugin;
import oracle.adf.share.services.ServiceRef;
import oracle.adf.share.services.Services;
import oracle.adf.share.services.ServicesFactory;
import oracle.adf.share.services.URLDescriptor;

public class ResourceService {
    public static final String SERVICE_NAME = "oracle.adf.common.services.ResourceService";
    public static final String WILDCARD_TYPE = "*";
    private static final Logger logger = Logger.getLogger(ResourceService.class.getName());
    private DescriptorContextFactory descrCtxFactory = DescriptorContextFactory.getInstance();
    private StrategyVisitor visitor = null;

    public void setStrategyVisitor(StrategyVisitor visitor) {
        this.visitor = visitor;
    }

    public Collection<URLDescriptor> getResourcesForType(ClassLoader classLoader, String resourceType) {
        if (classLoader == null) {
            return Collections.emptyList();
        }
        ArrayList<URLDescriptor> descriptors = new ArrayList<URLDescriptor>();
        try {
            block2: for (ServiceRef ref : ServicesFactory.findServiceRefs(SERVICE_NAME, classLoader)) {
                Services svcObj = ref.getService();
                if (!(svcObj instanceof Services)) continue;
                Services binding = svcObj;
                DescriptorContext dctx = this.descrCtxFactory.getContext(this.getBaseURL(binding.getServiceURL()));
                for (ServicePlugin plugin : binding.getPlugins()) {
                    if (!WILDCARD_TYPE.equals(resourceType) && !plugin.getServiceType().equals(resourceType)) continue;
                    List<URLDescriptor> tokenizedList = plugin.getTokenizedResources(dctx);
                    if (tokenizedList != null) {
                        descriptors.addAll(tokenizedList);
                        continue;
                    }
                    if (logger.isLoggable(Level.FINE) && plugin.getServiceType().equals("ADF_DataControl")) {
                        logger.fine("Unmigrated: " + binding.getServiceURL());
                    }
                    if (this.getStrategyResources(plugin, dctx, classLoader, descriptors)) continue;
                    continue block2;
                }
            }
        }
        catch (Exception e) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            throw new RuntimeException(e);
        }
        if (descriptors.size() > 0) {
            return Collections.unmodifiableList(descriptors);
        }
        return Collections.emptyList();
    }

    private final boolean getStrategyResources(ServicePlugin plugin, DescriptorContext dctx, ClassLoader classLoader, ArrayList<URLDescriptor> descriptors) throws InstantiationException, IllegalAccessException, InvocationTargetException {
        ResourceServiceStrategy strategy = null;
        try {
            strategy = plugin.getServiceStrategy(dctx);
        }
        catch (RuntimeException x) {
            logger.log(Level.INFO, plugin.getServiceType(), x);
        }
        catch (ClassNotFoundException e) {
            this.logBackwardCompatibilityAllowance(plugin);
        }
        if (strategy != null) {
            if (this.visitor != null) {
                boolean keepVisiting = this.visitor.visitStrategy(strategy, dctx, descriptors, plugin, classLoader, this);
                if (!keepVisiting) {
                    return false;
                }
            } else {
                descriptors.addAll(strategy.getResources(dctx));
            }
        }
        return true;
    }

    private void logBackwardCompatibilityAllowance(ServicePlugin plugin) {
        logger.info("Ignored missing resource strategy: " + plugin);
    }

    public Collection<URLDescriptor> getResourcesForType(String resourceType) {
        return this.getResourcesForType(this.getClassLoader(), resourceType);
    }

    public ClassLoader getClassLoader() {
        return ClassUtils.getClassLoader(this.getClass());
    }

    public Collection<ServicePlugin> getPluginsForType(String resourceType) throws IOException {
        return this.getPluginsForType(this.getClassLoader(), resourceType);
    }

    public Collection<ServicePlugin> getPluginsForType(ClassLoader classLoader, String resourceType) throws IOException {
        if (classLoader == null) {
            return Collections.emptyList();
        }
        ArrayList<ServicePlugin> plugins = new ArrayList<ServicePlugin>();
        for (ServiceRef ref : ServicesFactory.findServiceRefs(SERVICE_NAME, classLoader)) {
            Services svcObj = ref.getService();
            if (!(svcObj instanceof Services)) continue;
            Services binding = svcObj;
            for (ServicePlugin plugin : binding.getPlugins()) {
                if (!WILDCARD_TYPE.equals(resourceType) && !plugin.getServiceType().equals(resourceType)) continue;
                plugins.add(plugin);
            }
        }
        if (plugins.size() > 0) {
            return Collections.unmodifiableList(plugins);
        }
        return Collections.emptyList();
    }

    private URL getBaseURL(URL jarUrl) {
        URL ret = null;
        try {
            String path = jarUrl.toExternalForm();
            int lastIndex = path.lastIndexOf(ServicesFactory.getServiceFileName(SERVICE_NAME));
            if (lastIndex >= 0) {
                String baseUrl_str = path.substring(0, lastIndex);
                ret = new URL(baseUrl_str);
            }
            return ret;
        }
        catch (MalformedURLException e) {
            return null;
        }
    }

    public static interface StrategyVisitor {
        public boolean visitStrategy(ResourceServiceStrategy var1, DescriptorContext var2, List<URLDescriptor> var3, ServicePlugin var4, ClassLoader var5, ResourceService var6);
    }
}

