/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.rest.filter;

import java.util.Locale;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class RestHttpRequestWrapper
extends HttpServletRequestWrapper {
    private String metadataContextValue = null;
    private Locale locale = null;
    private String pathPostMetadataContextProcessing = null;

    public RestHttpRequestWrapper(HttpServletRequest httpServletRequest) {
        super(httpServletRequest);
    }

    public Locale getLocale() {
        if (this.locale != null) {
            return this.locale;
        }
        return super.getLocale();
    }

    public String getHeader(String headerName) {
        if (headerName.equals("Metadata-Context") && this.metadataContextValue != null && !this.metadataContextValue.equals("default")) {
            if (this.metadataContextValue.equals("tip")) {
                return "revision=" + this.metadataContextValue;
            }
            if (this.isSB()) {
                return "sandbox=\"" + this.getMetadataContextHeaderValue() + "\"";
            }
            if (this.isRV()) {
                return "revision=\"" + this.getMetadataContextHeaderValue() + "\"";
            }
            return "revision=\"" + this.metadataContextValue + "\"";
        }
        return super.getHeader(headerName);
    }

    public String getPathInfo() {
        if (this.pathPostMetadataContextProcessing != null) {
            return this.pathPostMetadataContextProcessing;
        }
        return super.getPathInfo();
    }

    public void setMetadataContextValue(String value) {
        this.metadataContextValue = value;
    }

    public void setLocaleValue(Locale value) {
        this.locale = value;
    }

    public void setPathPostMetadataContextProcessing(String value) {
        this.pathPostMetadataContextProcessing = value;
    }

    public boolean isSB() {
        return this.metadataContextValue != null && this.metadataContextValue.indexOf("sb") != -1 && this.metadataContextValue.indexOf(":") != -1 && this.metadataContextValue.substring(0, this.metadataContextValue.indexOf(":")).trim().equals("sb");
    }

    public boolean isRV() {
        return this.metadataContextValue != null && this.metadataContextValue.indexOf("rv") != -1 && this.metadataContextValue.indexOf(":") != -1 && this.metadataContextValue.substring(0, this.metadataContextValue.indexOf(":")).trim().equals("rv");
    }

    public String getMetadataContextHeaderValue() {
        String val = null;
        val = this.metadataContextValue.substring(this.metadataContextValue.indexOf(":") + 1);
        if ((val = val.trim()).length() == 0) {
            return null;
        }
        return val;
    }
}

