/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.perf.analysis;

import java.util.Comparator;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.Vector;
import oracle.adf.share.perf.analysis.Analyzer;
import oracle.adf.share.perf.analysis.CounterResult;
import oracle.adf.share.perf.analysis.SensorResult;
import oracle.adf.share.perf.analysis.StateResult;
import oracle.adf.share.perf.analysis.TimerResult;

class SensorAnalyzer
extends Analyzer {
    private Vector mSensorResults = new Vector();

    SensorAnalyzer() {
    }

    @Override
    void addSensor(int index, String name, String type) {
        if (index + 1 > this.mSensorResults.size()) {
            this.mSensorResults.setSize(index + 1);
        }
        super.addSensor(index, name, type);
    }

    @Override
    void analyseLine(String line) {
        StringTokenizer st = new StringTokenizer(line, " [");
        st.nextToken();
        while (st.hasMoreTokens()) {
            int index = Integer.parseInt(st.nextToken(" []"));
            st.nextToken();
            st.nextToken();
            String value = st.nextToken("]").substring(1);
            SensorResult result = (SensorResult)this.mSensorResults.get(index);
            if (sSensorTypes.get(index).equals("t")) {
                if (result == null) {
                    result = new TimerResult(index);
                    this.mSensorResults.set(index, result);
                }
            } else {
                if (sTimerOnly) continue;
                if (sSensorTypes.get(index).equals("c")) {
                    if (result == null) {
                        result = new CounterResult(index);
                        this.mSensorResults.set(index, result);
                    }
                } else if (sSensorTypes.get(index).equals("s") && result == null) {
                    result = new StateResult(index);
                    this.mSensorResults.set(index, result);
                }
            }
            if (result == null || this.isFiltered(result)) continue;
            result.setValue(value);
        }
    }

    @Override
    void print() {
        int size = this.mSensorResults.size();
        TreeSet<SensorResult> resultSet = new TreeSet<SensorResult>(new SensorComparator());
        for (int i = 0; i < size; ++i) {
            SensorResult result = (SensorResult)this.mSensorResults.get(i);
            if (result == null) continue;
            resultSet.add(result);
        }
        Iterator<SensorResult> it = resultSet.iterator();
        for (int count = 0; it.hasNext() && count < Analyzer.sNumTopUrls; ++count) {
            it.next().print(sOut, false, "");
        }
    }

    private class SensorComparator
    implements Comparator<SensorResult> {
        private SensorComparator() {
        }

        @Override
        public int compare(SensorResult s1, SensorResult s2) {
            if (s1.mElapseTime <= s2.mElapseTime) {
                return 1;
            }
            return -1;
        }
    }
}

