/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.metrics;

import java.util.logging.Level;
import oracle.adf.share.logging.internal.perf.BridgedMetricFactory;
import oracle.adf.share.metrics.Counter;
import oracle.adf.share.metrics.Metric;
import oracle.adf.share.metrics.StateTracker;
import oracle.adf.share.metrics.Timer;
import oracle.adfinternal.share.util.ProviderUtil;

public class MetricFactory {
    protected MetricFactory() {
    }

    protected boolean isActive(Level level) {
        return Metric.LevelHolder.INST.isLoggable(level);
    }

    public Counter createCounter(Level level, String groupName, String name, String type, String desc) {
        return Counter.DUMMY_COUNTER;
    }

    public Timer createTimer(Level level, String groupName, String name, String type, String desc) {
        return Timer.DUMMY_TIMER;
    }

    public StateTracker createStateTracker(Level level, String groupName, String name, String type, byte valueType, String unit, String desc) {
        return StateTracker.DUMMY_STATE_TRACKER;
    }

    public Counter createCounter(Level level, String groupName, String name, String type, String desc, String tags) {
        return this.createCounter(level, groupName, name, type, desc);
    }

    public Timer createTimer(Level level, String groupName, String name, String type, String desc, String tags) {
        return this.createTimer(level, groupName, name, type, desc);
    }

    public StateTracker createStateTracker(Level level, String groupName, String name, String type, byte valueType, String unit, String desc, String tags) {
        return this.createStateTracker(level, groupName, name, type, valueType, unit, desc);
    }

    public void removeApplicationMetrics(String ... removeStrs) {
    }

    private static MetricFactory initMetricFactory() {
        MetricFactory mf = null;
        mf = ProviderUtil.loadProviderPlugin(MetricFactory.class);
        if (mf == null) {
            mf = new BridgedMetricFactory();
        }
        return mf;
    }

    static /* synthetic */ MetricFactory access$000() {
        return MetricFactory.initMetricFactory();
    }

    protected static class FactoryHolder {
        public static final MetricFactory INST = MetricFactory.access$000();

        protected FactoryHolder() {
        }
    }
}

