/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging.internal.diagnostic;

import java.util.logging.Level;
import oracle.adf.share.common.impl.StackTraceAnalyzer;
import oracle.adf.share.logging.internal.diagnostic.ADFLogRecord;

public class JBODiagnosticLogRecord
extends ADFLogRecord {
    private static final long serialVersionUID = -1141654773305349587L;
    private transient boolean __needToInferCaller = true;

    public JBODiagnosticLogRecord(Level level, String msg) {
        super(level, msg);
    }

    @Override
    public String getSourceClassName() {
        if (this.__needToInferCaller) {
            this._inferCaller();
        }
        return super.getSourceClassName();
    }

    @Override
    public String getSourceMethodName() {
        if (this.__needToInferCaller) {
            this._inferCaller();
        }
        return super.getSourceMethodName();
    }

    @Override
    public void setSourceClassName(String sourceClassName) {
        this.__needToInferCaller = false;
        super.setSourceClassName(sourceClassName);
    }

    @Override
    public void setSourceMethodName(String sourceMethodName) {
        this.__needToInferCaller = false;
        super.setSourceMethodName(sourceMethodName);
    }

    private void _inferCaller() {
        this.__needToInferCaller = false;
        StackTraceElement frame = new StackTraceAnalyzer().getCallerFrame(new StackTraceAnalyzer.StackTraceElementChecker(){

            @Override
            public boolean isRelevantFrame(StackTraceElement frame) {
                return "oracle.jbo.common.Diagnostic".equals(frame.getClassName());
            }
        });
        if (frame != null) {
            this.setSourceClassName(frame.getClassName());
            this.setSourceMethodName(frame.getMethodName());
            return;
        }
        this.setSourceClassName(null);
        this.setSourceMethodName(null);
    }
}

