/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging.internal.diagnostic;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import oracle.adf.share.common.impl.StackTraceAnalyzer;
import oracle.adf.share.logging.internal.diagnostic.ADFLoggerWrapperException;

public class ADFLogRecord
extends LogRecord {
    private static final long serialVersionUID = 3004546892411290289L;
    private transient boolean _needToInferCaller = true;
    private static final String _JDK_LOG_CLASS = "java.util.logging.Logger";
    private static final String _ADF_LOG_CLASS = "oracle.adf.share.logging.ADFLogger";
    private transient String _LOG_CLASS = "oracle.adf.share.logging.ADFLogger";

    public ADFLogRecord(Level level, String msg) {
        super(level, msg);
    }

    public ADFLogRecord(Class logger, Level level, String msg) {
        this(level, msg);
        if (logger != null) {
            this._LOG_CLASS = logger.getName();
        }
    }

    public ADFLogRecord(String loggerClassName, Level level, String msg) {
        this(level, msg);
        if (loggerClassName != null) {
            this._LOG_CLASS = loggerClassName;
        }
    }

    @Override
    public String getSourceClassName() {
        if (this._needToInferCaller) {
            this._inferCaller();
        }
        return super.getSourceClassName();
    }

    @Override
    public void setSourceClassName(String sourceClassName) {
        this._needToInferCaller = false;
        super.setSourceClassName(sourceClassName);
    }

    @Override
    public String getSourceMethodName() {
        if (this._needToInferCaller) {
            this._inferCaller();
        }
        return super.getSourceMethodName();
    }

    @Override
    public void setSourceMethodName(String sourceMethodName) {
        this._needToInferCaller = false;
        super.setSourceMethodName(sourceMethodName);
    }

    private void _inferCaller() {
        this._needToInferCaller = false;
        StackTraceAnalyzer a = new StackTraceAnalyzer();
        StackTraceElement frame = a.getCallerFrame(new StackTraceAnalyzer.StackTraceElementChecker(){

            @Override
            public boolean isRelevantFrame(StackTraceElement frame) {
                String cname = frame.getClassName();
                return cname.equals(ADFLogRecord._JDK_LOG_CLASS) || cname.equals(ADFLogRecord._ADF_LOG_CLASS) || cname.equals(ADFLogRecord.this._LOG_CLASS);
            }
        }, new StackTraceAnalyzer.StackTraceElementChecker(){

            @Override
            public boolean isRelevantFrame(StackTraceElement frame) {
                String mname = frame.getMethodName();
                return "log".equals(mname) || "_log".equals(mname);
            }
        });
        if (frame != null) {
            this.setSourceClassName(frame.getClassName());
            this.setSourceMethodName(frame.getMethodName());
            return;
        }
        this.setSourceClassName(null);
        this.setSourceMethodName(null);
    }

    @Override
    public void setThrown(Throwable thrown) {
        if (null == thrown) {
            super.setThrown(null);
        } else {
            super.setThrown(new ADFLoggerWrapperException(thrown));
        }
    }

    @Override
    public Throwable getThrown() {
        Throwable thrown = super.getThrown();
        if (thrown != null && ADFLoggerWrapperException.class.isAssignableFrom(thrown.getClass())) {
            return ((ADFLoggerWrapperException)thrown).getWrappedException();
        }
        return null;
    }

    @Override
    public void setParameters(Object[] parameters) {
        String[] strings = null;
        if (parameters != null) {
            int size = parameters.length;
            strings = new String[size];
            for (int i = 0; i < size; ++i) {
                if (parameters[i] == null) continue;
                strings[i] = parameters[i].toString();
            }
        }
        super.setParameters(strings);
    }
}

