/*
 * Decompiled with CFR 0.152.
 */
package oracle.adf.share.logging;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import oracle.adf.share.common.impl.StackTraceAnalyzer;
import oracle.adf.share.logging.ADFLogger;
import oracle.dms.context.DMSContextManager;

public class ADFLoggerUtil {
    private static final String ORACLE_ADFDIAGNOSTICS_LOGGER = "oracle.adfdiagnostics";
    private static final String ORACLE_ADFDIAGNOSTICS_SECURITY_LOGGER = "oracle.adfdiagnostics.security";
    private static final String ADFLOGGERMODULE = "oracle.adf.share.logging.ADFLogger";
    private static final ADFLogger utilLogger = ADFLogger.createADFLogger(ADFLoggerUtil.class);
    private static final ADFLogger adfDiagnosticsLogger = ADFLogger.createADFLogger("oracle.adfdiagnostics");
    private static final ADFLogger adfDiagnosticsSecurityLogger = ADFLogger.createADFLogger("oracle.adfdiagnostics.security");
    public static final String ADF_LOGGER_MESSAGE_BUNDLE = "oracle.adf.share.logging.resources.LoggerMessageBundle";

    public static ADFLogger getADFDiagnosticsLogger() {
        return adfDiagnosticsLogger;
    }

    public static ADFLogger getADFDiagnosticsSecurityLogger() {
        return adfDiagnosticsSecurityLogger;
    }

    public static boolean isADFComponentAdded(Map<String, String> contextData) {
        if (contextData != null && contextData.containsKey("Component")) {
            return true;
        }
        utilLogger.info(MessageFormat.format(ResourceBundle.getBundle(ADF_LOGGER_MESSAGE_BUNDLE).getString("ADF_COMPONENT_NAME_MISSING"), contextData.toString()));
        return false;
    }

    public static String getModuleName(final String methodName) {
        String cname = "";
        StackTraceElement el = new StackTraceAnalyzer().getCallerFrame(new StackTraceAnalyzer.StackTraceElementChecker(){

            @Override
            public boolean isRelevantFrame(StackTraceElement se) {
                return ADFLoggerUtil.ADFLOGGERMODULE.equals(se.getClassName()) && se.getMethodName().equals(methodName);
            }
        });
        if (el != null) {
            cname = el.getClassName();
        }
        return cname;
    }

    public static String convertContextDataMap(Map<String, String> map) {
        if (map == null || map.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(1024);
        for (String key : map.keySet()) {
            sb.append(key).append("=").append(map.get(key)).append(";#;");
        }
        String data = sb.toString();
        data = data.substring(0, data.length() - ";#;".length());
        return data;
    }

    @Deprecated
    public static String convertContextDataMap(HashMap<String, String> payload) {
        if (payload == null || payload.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(1024);
        for (String key : payload.keySet()) {
            sb.append(key).append("=").append(payload.get(key)).append(";#;");
        }
        String data = sb.toString();
        data = data.substring(0, data.length() - ";#;".length());
        return data;
    }

    public static void setSupplementalAttributes() {
        DMSContextManager.setKeyAttribute((String)"ADF_MESSAGE_CONTEXT_DATA", (int)1);
        DMSContextManager.setKeyAttribute((String)"ADF_MESSAGE_ACTION_NAME", (int)1);
        DMSContextManager.setKeyAttribute((String)"ADF_MESSAGE_ACTION_DESC", (int)1);
        DMSContextManager.setKeyAttribute((String)"ADF_MESSAGE_STATUS", (int)1);
        DMSContextManager.setKeyAttribute((String)"ADF_MESSAGE_DEFAULT_CONTEXT_DATA", (int)1);
        DMSContextManager.setKeyAttribute((String)"PARENT_REQUEST_ECID", (int)1);
        DMSContextManager.setKeyAttribute((String)"CUSTOM_APPLICATION_NAME", (int)1);
        DMSContextManager.setKeyAttribute((String)"CUSTOM_APPLICATION_MODE", (int)1);
        DMSContextManager.setKeyAttribute((String)"CUSTOM_APPLICATION_USER_ID", (int)1);
    }
}

