/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.utility;

import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import oracle.dbtools.common.utils.MetaResource;
import oracle.dbtools.common.utils.Version;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.extension.apex.exceptions.AppNotInstalledException;
import oracle.dbtools.extension.apex.exceptions.InvalidApexExportException;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.query.QueryXMLSupport;

public class QueryUtils {
    static QueryXMLSupport s_xml = null;
    public static String _version = "";

    public static synchronized QueryXMLSupport getXMLQueries() {
        if (s_xml == null) {
            s_xml = QueryXMLSupport.getQueryXMLSupport((MetaResource)new MetaResource(QueryUtils.class.getClassLoader(), "oracle/dbtools/extension/apex/xml/ApexCommandQueries.xml"));
        }
        return s_xml;
    }

    public static void loadAppDetail(Connection conn, ScriptRunnerContext ctx, BigDecimal appId) throws SQLException, InvalidApexExportException {
        if (appId == null) {
            throw new InvalidApexExportException();
        }
        PreparedStatement stmt = conn.prepareStatement(QueryUtils.getXMLQueries().getQuery("getAppDetails", conn).getSql());
        stmt.setBigDecimal(1, appId);
        ResultSet result = stmt.executeQuery();
        while (result.next()) {
            ctx.getParameterInstance().putParameter("apex.parms", "workspaceid", (Object)result.getBigDecimal(1));
            if (ctx.getParameterInstance().getParameter("apex.parms", "workspacename") == null || ctx.getParameterInstance().getParameter("apex.parms", "workspacename").toString().length() <= 0) {
                ctx.getParameterInstance().putParameter("apex.parms", "workspacename", (Object)result.getString(2));
            }
            ctx.getParameterInstance().putParameter("apex.parms", "applicationname", (Object)result.getString(3));
        }
        result.close();
        stmt.close();
    }

    public static boolean newApexVersion(Connection conn) throws AppNotInstalledException {
        String cleanversion;
        DBUtil dbUtil = DBUtil.getInstance((Connection)conn);
        String version = dbUtil.executeReturnOneCol(QueryUtils.getXMLQueries().getQuery("apex.version", conn).getSql());
        if (version == null || version.isEmpty()) {
            throw new AppNotInstalledException();
        }
        _version = cleanversion = version.replaceAll("-", "");
        Version source = new Version(cleanversion);
        return source.compareTo(new Version("19.2")) > 0;
    }
}

