/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.extension.apex.command;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import oracle.dbtools.extension.SQLCLService;
import oracle.dbtools.extension.apex.command.ApexOptions;
import oracle.dbtools.extension.apex.core.APEXExport;
import oracle.dbtools.extension.apex.exceptions.AppNotInstalledException;
import oracle.dbtools.extension.apex.exceptions.InvalidApexExportException;
import oracle.dbtools.extension.apex.exceptions.OutputBufferNotInitialized;
import oracle.dbtools.extension.apex.help.ApexMessages;
import oracle.dbtools.extension.apex.utility.ApexUtil;
import oracle.dbtools.raptor.newscriptrunner.CommandListener;
import oracle.dbtools.raptor.newscriptrunner.IHelp;
import oracle.dbtools.raptor.newscriptrunner.ISQLCommand;
import oracle.dbtools.raptor.newscriptrunner.ScriptRunnerContext;
import oracle.dbtools.raptor.newscriptrunner.commands.Connected;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.CommandParserConstants;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.Help.CommandHelp;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.CommandHelpClassException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.CommandOptionsClassException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ConnectionNotValidException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ExtraParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.InvalidCommandException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.InvalidParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.MissingRequiredParameterException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.exception.ParameterFailedValidationException;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.interfaces.ICommandSyntax;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parameter.StandardParameter;
import oracle.dbtools.raptor.newscriptrunner.parameterparser.parser.CommandParser;

public class ApexCommand
extends CommandListener
implements IHelp,
SQLCLService,
Connected,
ICommandSyntax {
    public static ScriptRunnerContext ctx;
    private CommandHelp help;

    public static String exceptionToString(Exception e) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.print(e.getMessage() + "\r\n");
        while (e.getCause() != null) {
            e = (Exception)e.getCause();
            pw.print(e.getMessage() + "\r\n");
        }
        pw.flush();
        return sw.toString();
    }

    private static APEXExport getApexExporter(Connection conn, ScriptRunnerContext ctx) throws InvalidParameterException, AppNotInstalledException {
        APEXExport apexExport = new APEXExport();
        apexExport.setCtx(ctx);
        apexExport.setConnection(conn);
        apexExport.setCWD(ctx.prependCD(""));
        apexExport.setOutStream((OutputStream)ctx.getOutputStream());
        return apexExport;
    }

    public void beginEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public void endEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
    }

    public String getCommand() {
        return "apex";
    }

    public Class<? extends CommandListener> getCommandListener() {
        return ((Object)((Object)this)).getClass();
    }

    public String getCommandLongName() {
        return "apex";
    }

    public Map<String, Map<String, StandardParameter>> getCommandModel() {
        return ApexOptions.commandModel;
    }

    public String getCommandShortName() {
        return "ax";
    }

    public String getExtensionDescription() {
        return ApexMessages.getString("EXT_DESC");
    }

    public String getExtensionName() {
        return "apex";
    }

    public String getExtensionVersion() {
        return ApexMessages.getString("SQLclVersion.VERSION");
    }

    public String getHelp() {
        try {
            this.help = new CommandHelp(new ScriptRunnerContext(), ApexOptions.class);
            ScriptRunnerContext theCtx = new ScriptRunnerContext();
            this.help = new CommandHelp(theCtx, ApexOptions.class);
            CommandParser.loadParams((String)"apex.parms", (String)"apex help", (ScriptRunnerContext)theCtx, ApexOptions.class);
            return this.help.getCommandHelp();
        }
        catch (CommandHelpClassException | CommandOptionsClassException | ConnectionNotValidException | ExtraParameterException | InvalidCommandException | MissingRequiredParameterException | ParameterFailedValidationException e) {
            return ApexMessages.getString("HELP_ERROR");
        }
    }

    public boolean handleEvent(Connection conn, ScriptRunnerContext ctx, ISQLCommand cmd) {
        ApexCommand.ctx = ctx;
        if (!cmd.getLoweredTrimmedNoWhitespaceSQL().startsWith("apex")) {
            return false;
        }
        System.setProperty("user.dir", ctx.prependCD(""));
        try {
            this.help = new CommandHelp(ctx, ApexOptions.class);
            CommandParser.loadParams((String)"apex.parms", (String)cmd.getSql(), (ScriptRunnerContext)ctx, ApexOptions.class, (boolean)true, (boolean)true);
            String _command = ctx.getParameterInstance().getParameterAsString("apex.parms", CommandParserConstants.COMMAND);
            boolean _help = ctx.getParameterInstance().getParameterAsBoolean("apex.parms", CommandParserConstants.HELP);
            if (_help) {
                ctx.write(this.help.getCommandHelp());
                return true;
            }
            if (conn == null) {
                ctx.write(ApexMessages.getString("ApexCmd.7"));
                ctx.errorLog(ctx.getSourceRef(), ApexMessages.getString("ApexCmd.7"), cmd.getSql());
                return true;
            }
            try {
                ApexUtil.newApexVersion(conn);
            }
            catch (AppNotInstalledException e) {
                ctx.write(ApexMessages.getString("NOT_INSTALLED") + "\n");
                return true;
            }
            String report = null;
            APEXExport apexExport = ApexCommand.getApexExporter(conn, ctx);
            switch (_command) {
                case "list": {
                    report = "apex.list";
                    ApexUtil.printList(conn, ctx, report);
                    ctx.write(System.lineSeparator());
                    break;
                }
                case "log": {
                    report = "apex.log";
                    ApexUtil.printList(conn, ctx, report);
                    ctx.write(System.lineSeparator());
                    break;
                }
                case "export": {
                    apexExport.doCapture();
                    ctx.write(System.lineSeparator());
                    break;
                }
                case "export-feedback": {
                    apexExport.ExportFeedback();
                    ctx.write(System.lineSeparator());
                    break;
                }
                case "export-workspace": {
                    apexExport.ExportWorkspace();
                    ctx.write(System.lineSeparator());
                    break;
                }
                case "export-all-workspaces": {
                    apexExport.ExportAllWorkspaces();
                    ctx.write(System.lineSeparator());
                    break;
                }
                case "export-static-files": {
                    apexExport.ExportStaticFiles();
                    ctx.write(System.lineSeparator());
                    break;
                }
                case "export-application": {
                    apexExport.ExportAllApplications();
                    ctx.write(System.lineSeparator());
                    break;
                }
                case "export-instance": {
                    apexExport.ExportInstance();
                    ctx.write(System.lineSeparator());
                    break;
                }
                case "export-components": {
                    apexExport.ExportComponents();
                    ctx.write(System.lineSeparator());
                    break;
                }
                case "export-all-applications": {
                    apexExport.ExportAllApplications();
                    ctx.write(System.lineSeparator());
                    break;
                }
                case "version": {
                    ctx.write("APEX Version " + ApexUtil._version + " is installed." + System.lineSeparator());
                    break;
                }
                default: {
                    this.help.getCommandHelp();
                }
            }
            return true;
        }
        catch (IOException | SQLException | AppNotInstalledException | InvalidApexExportException | OutputBufferNotInitialized | CommandHelpClassException | CommandOptionsClassException | ConnectionNotValidException | ExtraParameterException | InvalidCommandException | InvalidParameterException | MissingRequiredParameterException | ParameterFailedValidationException e) {
            ctx.write(ApexCommand.exceptionToString((Exception)e));
            if (ctx.getParameterInstance().getParameterAsBoolean("apex.parms", "debug").booleanValue()) {
                ctx.getParameterInstance().printParametersAsTable("apex.parms");
            }
            return true;
        }
    }

    public boolean isSqlPlus() {
        return false;
    }

    public boolean needsConnection() {
        return true;
    }
}

