/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.jar;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.ide.Context;
import oracle.ide.explorer.ChildFilterHelper;
import oracle.ide.model.ContentLevel;
import oracle.ide.model.ContentSet;
import oracle.ide.model.Node;
import oracle.ide.model.NonAutoSelectable;
import oracle.ide.model.Project;
import oracle.ide.model.WorkingSet;
import oracle.ide.model.WorkingSets;
import oracle.ide.model.Workspace;
import oracle.ide.net.JarUtil;
import oracle.ide.net.URLFileSystem;
import oracle.ide.net.URLPath;
import oracle.ide.util.IntersectedFilters;
import oracle.ide.util.PatternFilters;
import oracle.javatools.data.HashStructure;
import oracle.jdevimpl.jar.JarNode;

public final class JarFolder
extends JarNode
implements NonAutoSelectable {
    private static Integer FlatLevel;

    public JarFolder() {
        this(null);
    }

    public JarFolder(URL url) {
        super(url);
    }

    protected void closeImpl() throws IOException {
        super.closeImpl();
    }

    public boolean mayHaveChildren() {
        return true;
    }

    public Iterator getChildren() {
        ArrayList children = this.getChildrenList();
        return children.iterator();
    }

    ArrayList getChildrenList() {
        ArrayList children = new ArrayList();
        URL url = JarFolder.getJarURL(this.getURL());
        Context context = Context.newIdeContext((Node)this);
        if (FlatLevel != null) {
            context.setBoolean("flat-level-enabled", true);
            context.setInt("flat-level", FlatLevel.intValue());
        }
        PatternFilters patternFilters = JarFolder.getPatternFilters(context);
        if (context.getBoolean("show-root-dirs")) {
            IntersectedFilters filters = new IntersectedFilters(patternFilters);
            JarFolder.addURLPath(context, children, new URLPath(url), filters);
        } else {
            ContentSet libContents = new ContentSet(HashStructure.newInstance());
            URLPath libURLPath = libContents.getURLPath();
            libURLPath.add(new URLPath(url));
            ContentLevel contentLevel = ContentLevel.newInstanceForHideDirs((ContentSet)libContents, (PatternFilters)patternFilters, (boolean)true);
            contentLevel.addFlatDirs(context, children);
        }
        return children;
    }

    private static WorkingSet getWorkingSet(Context context) {
        if (context.getBoolean("enable-working-sets")) {
            Workspace workspace = context.getWorkspace();
            Project project = context.getProject();
            if (workspace != null && project != null) {
                return WorkingSets.getInstance((Workspace)workspace).getCurrentWorkingSet();
            }
        }
        return null;
    }

    private static void addURLPath(Context context, ArrayList jars, URLPath urlPath, IntersectedFilters filters) {
        if (urlPath != null) {
            for (URL url : urlPath) {
                ContentLevel contentLevel = ContentLevel.newInstanceForShowDirs((URL)url, (IntersectedFilters)filters, (boolean)true);
                jars.add(contentLevel.newFolder(context));
            }
        }
    }

    private static URL getJarURL(URL url) {
        if (!JarUtil.isJarURL((URL)url) && URLFileSystem.isRegularFile((URL)url)) {
            try {
                return new URL(String.format("jar:%s!/", url.toExternalForm()));
            }
            catch (MalformedURLException ex) {
                Logger.getLogger(JarFolder.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        return url;
    }

    private static PatternFilters getPatternFilters(Context context) {
        WorkingSet workingSet = JarFolder.getWorkingSet(context);
        if (workingSet == null) {
            return PatternFilters.getInstance((HashStructure)HashStructure.newInstance());
        }
        Project project = context.getProject();
        return project != null ? workingSet.getPatternFilters(project) : null;
    }

    public static class FilterHelper
    extends ChildFilterHelper {
        public void initChildren(Context context, List children) {
            FlatLevel = context.getInt("flat-level");
        }
    }
}

